"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Download = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _base64Js = require("base64-js");
var _fileSaver = _interopRequireDefault(require("file-saver"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Download extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onClick", () => {
      const {
        fileName,
        content
      } = this.props;
      const asset = (0, _lib.parseDataUrl)(content, true);
      if (asset && asset.data) {
        const assetBlob = new Blob([(0, _base64Js.toByteArray)(asset.data)], {
          type: asset.mimetype
        });
        const ext = asset.extension ? `.${asset.extension}` : '';
        _fileSaver.default.saveAs(assetBlob, `canvas-${fileName}${ext}`);
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasDownload",
      onClick: this.onClick,
      onKeyPress: this.onClick,
      tabIndex: 0,
      role: "button"
    }, this.props.children);
  }
}
exports.Download = Download;
(0, _defineProperty2.default)(Download, "propTypes", {
  children: _propTypes.default.element.isRequired,
  fileName: _propTypes.default.string.isRequired,
  content: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
});