"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmSourcesSettingsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _serverRouteRepository = require("@kbn/server-route-repository");
var _settings = require("./settings");
var _apm_indices = require("../saved_objects/apm_indices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createApmSourcesServerRoute = (0, _serverRouteRepository.createServerRouteFactory)();
// get apm indices configuration object
const apmIndicesRoute = createApmSourcesServerRoute({
  endpoint: 'GET /internal/apm-sources/settings/apm-indices',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: _settings.getApmIndices
});
const apmIndexSettingsRoute = createApmSourcesServerRoute({
  endpoint: 'GET /internal/apm-sources/settings/apm-index-settings',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: _settings.getApmIndexSettings
});
const saveApmIndicesRoute = createApmSourcesServerRoute({
  endpoint: 'POST /internal/apm-sources/settings/apm-indices/save',
  security: {
    authz: {
      requiredPrivileges: ['apm', 'apm_settings_write']
    }
  },
  params: t.type({
    body: t.partial({
      error: t.string,
      onboarding: t.string,
      span: t.string,
      transaction: t.string,
      metric: t.string,
      // Keeping this one here for backward compatibility
      sourcemap: t.string
    })
  }),
  handler: async ({
    params,
    context
  }) => {
    const {
      body: {
        sourcemap,
        ...indices
      }
    } = params;
    const coreContext = await context.core;
    return await (0, _apm_indices.saveApmIndices)(coreContext.savedObjects.client, indices);
  }
});
const apmSourcesSettingsRouteRepository = exports.apmSourcesSettingsRouteRepository = {
  ...apmIndicesRoute,
  ...apmIndexSettingsRoute,
  ...saveApmIndicesRoute
};