"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedTransactionsCorrelationsSortedByScore = getFailedTransactionsCorrelationsSortedByScore;
exports.getInitialResponse = void 0;
exports.getLatencyCorrelationsSortedByCorrelation = getLatencyCorrelationsSortedByCorrelation;
exports.getReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLatencyCorrelationsSortedByCorrelation(latencyCorrelations) {
  return latencyCorrelations.sort((a, b) => b.correlation - a.correlation);
}
function getFailedTransactionsCorrelationsSortedByScore(failedTransactionsCorrelations) {
  return failedTransactionsCorrelations.sort((a, b) => b.score - a.score);
}
const getInitialResponse = () => ({
  ccsWarning: false,
  isRunning: false,
  loaded: 0
});
exports.getInitialResponse = getInitialResponse;
const getReducer = () => (prev, update) => ({
  ...prev,
  ...update
});
exports.getReducer = getReducer;