"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decryptSecurityLabsContent = decryptSecurityLabsContent;
exports.encryptSecurityLabsContent = encryptSecurityLabsContent;
var _crypto = _interopRequireDefault(require("crypto"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-nodejs-modules

const key = _crypto.default.createHash('sha256').update('ELASTIC').digest();
const keyUint8 = key;

/**
 * Unsafe encryption function for security labs content.
 * @param text security labs content to encrypt
 * @returns Encrypted content as a hex string.
 */
function encryptSecurityLabsContent(text) {
  const cipher = _crypto.default.createCipheriv('aes-256-ecb', keyUint8, null);
  return cipher.update(text, 'utf8', 'hex') + cipher.final('hex');
}

/**
 * Decryption function for security labs content.
 * @param encrypted Encrypted security labs content as a hex string.
 * @returns Decrypted content as a string.
 */
function decryptSecurityLabsContent(encrypted) {
  const decipher = _crypto.default.createDecipheriv('aes-256-ecb', keyUint8, null);
  return decipher.update(encrypted, 'hex', 'utf8') + decipher.final('utf8');
}