"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.POSITIONS = exports.EuiProgress = exports.COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _inner_text = require("../inner_text");
var _predicate = require("../../services/predicate");
var _services = require("../../services");
var _progress = require("./progress.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SIZES = exports.SIZES = ['xs', 's', 'm', 'l'];
var COLORS = exports.COLORS = ['primary', 'success', 'warning', 'danger', 'subdued', 'accent', 'accentSecondary', 'vis0', 'vis1', 'vis2', 'vis3', 'vis4', 'vis5', 'vis6', 'vis7', 'vis8', 'vis9'];
var POSITIONS = exports.POSITIONS = ['fixed', 'absolute', 'static'];
var EuiProgress = exports.EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    max = _ref.max,
    _ref$valueText = _ref.valueText,
    valueText = _ref$valueText === void 0 ? false : _ref$valueText,
    label = _ref.label,
    value = _ref.value,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var determinate = !(0, _predicate.isNil)(max);
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyles = !isNamedColor ? {
    color: color
  } : {};
  var customTextColorStyles = !isNamedColor ? {
    color: (0, _services.makeHighContrastColor)(color)(euiTheme.euiTheme)
  } : {};
  var styles = (0, _progress.euiProgressStyles)(euiTheme, determinate);
  var cssStyles = [styles.euiProgress, determinate && styles.native, !determinate && styles.indeterminate, styles[size], styles[position], isNamedColor ? styles[color] : styles.customColor];
  var dataStyles = (0, _progress.euiProgressDataStyles)(euiTheme);
  var dataCssStyles = [dataStyles.euiProgress__data, size === 'l' && dataStyles[size]];
  var labelCssStyles = [_progress.euiProgressLabelStyles.euiProgress__label, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  var valueTextStyles = (0, _progress.euiProgressValueTextStyles)(euiTheme);
  var valueTextCssStyles = [valueTextStyles.euiProgress__valueText, isNamedColor ? valueTextStyles[color] : styles.customColor];
  var classes = (0, _classnames.default)('euiProgress', className);
  var labelClasses = (0, _classnames.default)('euiProgress__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var valueRender;
  if (valueText === true) {
    // valueText is true
    valueRender = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  }

  // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/

  if (determinate) {
    return (0, _react2.jsx)(_react.default.Fragment, null, label || valueText ? (0, _react2.jsx)("div", {
      css: dataCssStyles,
      className: "euiProgress__data"
    }, label && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", _extends({
        title: innerText,
        ref: ref
      }, labelProps, {
        className: labelClasses,
        css: labelCssStyles
      }), label);
    }), valueRender && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", {
        title: innerText,
        ref: ref,
        style: customTextColorStyles,
        css: valueTextCssStyles,
        className: "euiProgress__valueText"
      }, valueRender);
    })) : undefined, (0, _react2.jsx)("progress", _extends({
      css: cssStyles,
      className: classes,
      style: customColorStyles,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return (0, _react2.jsx)("div", _extends({
      css: cssStyles,
      style: customColorStyles,
      className: classes
    }, rest));
  }
};
EuiProgress.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any,
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  position: _propTypes.default.any,
  max: _propTypes.default.number,
  /*
       * If true, will render the percentage, otherwise pass a custom node
       */
  valueText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  label: _propTypes.default.node,
  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};