"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrepareIndicesForEvaluations = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrepareIndicesForEvaluations {
  constructor({
    esClient,
    indicesCreateRequests = [],
    indexRequests = [],
    logger
  }) {
    (0, _defineProperty2.default)(this, "esClient", void 0);
    (0, _defineProperty2.default)(this, "indicesCreateRequests", void 0);
    (0, _defineProperty2.default)(this, "indexRequests", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.esClient = esClient;
    this.indicesCreateRequests = indicesCreateRequests;
    this.indexRequests = indexRequests;
    this.logger = logger;
  }
  async setup() {
    this.logger.debug('Creating assistant indices for evaluations');
    await Promise.all([...this.indicesCreateRequests.map(index => this.esClient.indices.create(index)), ...this.indexRequests.map(indexRequest => this.esClient.index(indexRequest))]);
  }
  async cleanup() {
    this.logger.debug('Deleting assistant indices for evaluations');
    await Promise.all(this.indicesCreateRequests.map(index => this.esClient.indices.delete({
      index: index.index
    })));
  }
}
exports.PrepareIndicesForEvaluations = PrepareIndicesForEvaluations;