"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileClashWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileClashWarning = ({
  uploadStatus,
  filesStatus,
  removeClashingFiles
}) => {
  const fileClashes = uploadStatus.fileClashes;
  const clashType = fileClashes.some(fileClash => fileClash.clashType === _fileUpload.CLASH_TYPE.FORMAT) ? _fileUpload.CLASH_TYPE.FORMAT : fileClashes.some(fileClash => fileClash.clashType === _fileUpload.CLASH_TYPE.MAPPING) ? _fileUpload.CLASH_TYPE.MAPPING : _fileUpload.CLASH_TYPE.UNSUPPORTED;
  const {
    title,
    description
  } = clashType === _fileUpload.CLASH_TYPE.MAPPING ? {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.mappingClashTitle', {
      defaultMessage: 'Incompatible mapping'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.mappingClashDescription', {
      defaultMessage: 'Mappings in the selected files are not compatible with each other'
    })
  } : clashType === _fileUpload.CLASH_TYPE.FORMAT ? {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatClashTitle', {
      defaultMessage: 'Incompatible file formats'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatClashDescription', {
      defaultMessage: 'The selected files must have the same format. e.g. all CSV or all log files'
    })
  } : {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatNotSupportedTitle', {
      defaultMessage: 'File format not supported'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatNotSupportedDescription', {
      defaultMessage: 'Some of the selected files are not supported for upload.'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, description), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => removeClashingFiles(),
    color: "danger",
    size: "s",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileClashWarning.deleteAllButtonLabel",
    defaultMessage: "Delete all"
  })));
};
exports.FileClashWarning = FileClashWarning;