"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBsearchRoute = registerBsearchRoute;
var _rxjs = require("rxjs");
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerBsearchRoute(bfetch, getScoped, executionContextService) {
  bfetch.addBatchProcessingRoute('/internal/bsearch', request => {
    const search = getScoped(request);
    const abortSignal = (0, _.getRequestAbortedSignal)(request.events.aborted$);
    return {
      /**
       * @param requestOptions
       * @throws `KibanaServerError`
       */
      onBatchItem: async ({
        request: requestData,
        options
      }) => {
        const {
          executionContext,
          ...restOptions
        } = options || {};
        return executionContextService.withContext(executionContext, () => {
          _elasticApmNode.default.addLabels(executionContextService.getAsLabels());
          return (0, _rxjs.firstValueFrom)(search.search(requestData, {
            ...restOptions,
            abortSignal
          }).pipe((0, _rxjs.catchError)(err => {
            // Re-throw as object, to get attributes passed to the client
            // eslint-disable-next-line no-throw-literal
            throw {
              message: err.message,
              statusCode: err.statusCode,
              attributes: err.errBody ? {
                error: err.errBody.error,
                rawResponse: err.errBody.response,
                ...(err.requestParams ? {
                  requestParams: err.requestParams
                } : {})
              } : undefined
            };
          })));
        });
      }
    };
  });
}