"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.querySavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _query = require("./migrations/query");
var _query2 = require("./schemas/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const querySavedObjectType = exports.querySavedObjectType = {
  name: 'query',
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  management: {
    icon: 'search',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      return {
        path: `/app/discover#/?_a=(savedQuery:'${encodeURIComponent(obj.id)}')`,
        uiCapabilitiesPath: 'discover.show'
      };
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: _query2.SCHEMA_QUERY_MODEL_VERSION_1.extends({}, {
          unknowns: 'ignore'
        }),
        create: _query2.SCHEMA_QUERY_MODEL_VERSION_1
      }
    },
    2: {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          titleKeyword: {
            type: 'keyword'
          }
        }
      }, {
        type: 'data_backfill',
        backfillFn: doc => {
          return {
            attributes: {
              ...doc.attributes,
              titleKeyword: doc.attributes.title
            }
          };
        }
      }],
      schemas: {
        forwardCompatibility: _query2.SCHEMA_QUERY_MODEL_VERSION_2.extends({}, {
          unknowns: 'ignore'
        }),
        create: _query2.SCHEMA_QUERY_MODEL_VERSION_2
      }
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      titleKeyword: {
        type: 'keyword'
      },
      description: {
        type: 'text'
      }
    }
  },
  migrations: _query.savedQueryMigrations,
  schemas: {
    '8.8.0': _query2.SCHEMA_QUERY_V8_8_0
  }
};