"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogThrottledBuffer = createLogThrottledBuffer;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createLogThrottledBuffer({
  buffer$,
  stop$,
  maxThrottledMessages,
  bufferTimeMillis = 1_000
}) {
  const throttled$ = buffer$.asObservable().pipe((0, _rxjs.takeUntil)(stop$), (0, _rxjs.bufferTime)(bufferTimeMillis), (0, _rxjs.map)(statuses => {
    const aggregated =
    // aggregate repeated messages, and count nbr. of repetitions
    statuses.filter((candidateStatus, index) => {
      const firstMessageIndex = statuses.findIndex(status => candidateStatus.name === status.name && candidateStatus.level === status.level && candidateStatus.summary === status.summary);
      if (index !== firstMessageIndex) {
        var _statuses$firstMessag;
        // this is not the first time this message is logged, increase 'repeats' counter for the first occurrence
        statuses[firstMessageIndex].repeats = ((_statuses$firstMessag = statuses[firstMessageIndex].repeats) !== null && _statuses$firstMessag !== void 0 ? _statuses$firstMessag : 1) + 1;
        return false;
      } else {
        // this is the first time this message is logged, let it through
        return true;
      }
    });
    if (aggregated.length > maxThrottledMessages) {
      const list = [...new Set(aggregated.slice(maxThrottledMessages).map(({
        name
      }) => name))].join(', ');
      return [...aggregated.slice(0, maxThrottledMessages), `${aggregated.length - maxThrottledMessages} other status updates from [${list}] have been truncated to avoid flooding the logs`];
    } else {
      return aggregated;
    }
  }), (0, _rxjs.concatAll)());
  return throttled$;
}