/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.cases_bundle_jsonpfunction=self.cases_bundle_jsonpfunction||[]).push([[431],{2431:(e,t,a)=>{a.r(t),a.d(t,{FileUpload:()=>I,default:()=>R});var i=a(4286),l=a.n(i),s=a(9673),o=a(1319),r=a(3803),n=a(7880);function d(e){return(0,n.A)(e,e.getValue())}var u=a(6791),c=a(5008);const p={defaultPickerLabel:c.i18n.translate("sharedUXPackages.fileUpload.defaultFilePickerLabel",{defaultMessage:"Upload a file"}),fileEmpty:c.i18n.translate("sharedUXPackages.fileUpload.fileEmptyErrorMessage",{defaultMessage:"File is empty. Please provide a file with content."}),upload:c.i18n.translate("sharedUXPackages.fileUpload.uploadButtonLabel",{defaultMessage:"Upload"}),uploading:c.i18n.translate("sharedUXPackages.fileUpload.uploadingButtonLabel",{defaultMessage:"Uploading"}),uploadComplete:c.i18n.translate("sharedUXPackages.fileUpload.uploadCompleteButtonLabel",{defaultMessage:"Upload complete"}),retry:c.i18n.translate("sharedUXPackages.fileUpload.retryButtonLabel",{defaultMessage:"Retry"}),clear:c.i18n.translate("sharedUXPackages.fileUpload.clearButtonLabel",{defaultMessage:"Clear"}),cancel:c.i18n.translate("sharedUXPackages.fileUpload.cancelButtonLabel",{defaultMessage:"Cancel"}),uploadDone:c.i18n.translate("sharedUXPackages.fileUpload.uploadDoneToolTipContent",{defaultMessage:"Your file was successfully uploaded!"}),fileTooLarge:e=>c.i18n.translate("sharedUXPackages.fileUpload.fileTooLargeErrorMessage",{defaultMessage:"File is too large. Maximum size is {expectedSize, plural, one {# byte} other {# bytes} }.",values:{expectedSize:e}}),mimeTypeNotSupported:(e,t)=>c.i18n.translate("sharedUXPackages.fileUpload.mimeTypeNotSupportedErrorMessage",{defaultMessage:'File mime type "{mimeType}" is not supported. Supported mime types are: {supportedMimeTypes}.',values:{mimeType:e,supportedMimeTypes:t}})},h=l().createContext(null),f=()=>l().useContext(h),m=({onClick:e})=>{const t=f(),a=d(t.uploading$),i=d(t.error$),l=(0,n.A)(t.done$),s=(0,n.A)(t.files$,[]);return(0,u.jsx)(o.EuiButton,{key:"uploadButton",isLoading:a,color:l?"success":"primary",iconType:l?"checkInCircleFilled":void 0,disabled:Boolean(!s.length||i||l),onClick:e,size:"s","data-test-subj":"uploadButton"},l?p.uploadComplete:a?p.uploading:p.upload)},g=({onClick:e})=>{const t=d(f().uploading$);return(0,u.jsx)(o.EuiButton,{key:"retryButton",size:"s","data-test-subj":"retryButton",disabled:t,onClick:e},p.retry)},b=({onClick:e,compressed:t})=>{const a=!d(f().uploading$);return t?(0,u.jsx)(o.EuiButtonIcon,{color:"danger","data-test-subj":"cancelButtonIcon",disabled:a,iconType:"cross","aria-label":p.cancel,onClick:e}):(0,u.jsx)(o.EuiButton,{key:"cancelButton",size:"s","data-test-subj":"cancelButton",disabled:a,onClick:e,color:"danger"},p.cancel)},w=({onCancel:e,onUpload:t,immediate:a,compressed:i})=>{const l=f(),s=d(l.uploading$),o=(0,n.A)(l.files$,[]),r=Boolean(o.some((e=>"upload_failed"===e.status)));return i||s?(0,u.jsx)(b,{compressed:i,onClick:e}):r?(0,u.jsx)(g,{onClick:t}):a?null:(0,u.jsx)(m,{onClick:t})},M=({onClick:e})=>(0,u.jsx)(o.EuiButtonEmpty,{size:"s","data-test-subj":"clearButton",onClick:e,color:"primary"},p.clear),{euiFormMaxWidth:x,euiButtonHeightSmall:v}=r.euiThemeVars,y={horizontalContainer:{name:"ho1qnd",styles:"display:flex;flex-direction:row"},fullWidth:{name:"1d3w5wq",styles:"width:100%"}},U=l().forwardRef((({compressed:e,meta:t,accept:a,immediate:i,allowClear:s=!1,multiple:r,initialFilePromptText:c,fullWidth:h,className:m},g)=>{const{euiTheme:b}=(0,o.useEuiTheme)(),U=f(),j=d(U.uploading$),$=d(U.error$),S=(0,n.A)(U.done$),E=Boolean($),k=null==$?void 0:$.message,B=(0,o.useGeneratedHtmlId)({prefix:"filesFileUpload"}),C=`${B}_error`;return(0,u.jsx)("div",{"data-test-subj":"filesFileUpload",css:[(0,u.css)("max-width:",h?"100%":x,";",""),h?y.fullWidth:void 0,e?y.horizontalContainer:void 0,"",""],className:m},(0,u.jsx)(o.EuiFilePicker,{fullWidth:h,"aria-label":p.defaultPickerLabel,id:B,ref:g,onChange:e=>{U.setFiles(Array.from(null!=e?e:[])),i&&U.hasFiles()&&U.upload(t)},multiple:r,initialPromptText:c,isLoading:j,isInvalid:E,accept:a,disabled:Boolean((null==S?void 0:S.length)||j),"aria-describedby":k?C:void 0,display:e?"default":"large"}),(0,u.jsx)(o.EuiSpacer,{size:"s",css:e?(0,u.css)("width:",b.size.s,";",""):void 0}),(0,u.jsx)(o.EuiFlexGroup,{justifyContent:"flexStart",alignItems:e?"center":"flexStart",direction:e?void 0:"rowReverse",gutterSize:e?"none":"m",responsive:!1},(0,u.jsx)(o.EuiFlexItem,{grow:!1},(0,u.jsx)(w,{compressed:e,immediate:i,onCancel:U.abort,onUpload:()=>U.upload(t)})),!e&&Boolean(!S&&!j&&k)&&(0,u.jsx)(o.EuiFlexItem,null,(0,u.jsx)(o.EuiText,{"data-test-subj":"error",css:(0,u.css)("display:flex;align-items:center;min-height:",v,";",""),size:"s",color:"danger"},(0,u.jsx)("span",{id:C},k))),!e&&(null==S?void 0:S.length)&&s&&(0,u.jsx)(l().Fragment,null,(0,u.jsx)(o.EuiFlexItem,null)," ",(0,u.jsx)(o.EuiFlexItem,{grow:!1},(0,u.jsx)(M,{onClick:U.clear})))))}));var j=a(8915),$=a(190),S=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","#","$","%","*","+",",","-",".",":",";","=","?","@","[","]","^","_","{","|","}","~"],E=(e,t)=>{var a="";for(let i=1;i<=t;i++){let l=Math.floor(e)/Math.pow(83,t-i)%83;a+=S[Math.floor(l)]}return a},k=e=>{let t=e/255;return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},B=e=>{let t=Math.max(0,Math.min(1,e));return t<=.0031308?Math.trunc(12.92*t*255+.5):Math.trunc(255*(1.055*Math.pow(t,.4166666666666667)-.055)+.5)},C=(e,t)=>(e=>e<0?-1:1)(e)*Math.pow(Math.abs(e),t),F=class extends Error{constructor(e){super(e),this.name="ValidationError",this.message=e}},T=(e,t,a,i)=>{let l=0,s=0,o=0,r=4*t;for(let n=0;n<t;n++){let t=4*n;for(let d=0;d<a;d++){let a=t+d*r,u=i(n,d);l+=u*k(e[a]),s+=u*k(e[a+1]),o+=u*k(e[a+2])}}let n=1/(t*a);return[l*n,s*n,o*n]},P=(e,t,a,i,l)=>{if(i<1||i>9||l<1||l>9)throw new F("BlurHash must have between 1 and 9 components");if(t*a*4!==e.length)throw new F("Width and height must match the pixels array");let s=[];for(let o=0;o<l;o++)for(let l=0;l<i;l++){let i=0==l&&0==o?1:2,r=T(e,t,a,((e,s)=>i*Math.cos(Math.PI*l*e/t)*Math.cos(Math.PI*o*s/a)));s.push(r)}let o,r=s[0],n=s.slice(1),d="";if(d+=E(i-1+9*(l-1),1),n.length>0){let e=Math.max(...n.map((e=>Math.max(...e)))),t=Math.floor(Math.max(0,Math.min(82,Math.floor(166*e-.5))));o=(t+1)/166,d+=E(t,1)}else o=1,d+=E(0,1);return d+=E((e=>(B(e[0])<<16)+(B(e[1])<<8)+B(e[2]))(r),4),n.forEach((e=>{d+=E(((e,t)=>19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*C(e[0]/t,.5)+9.5))))*19+19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*C(e[1]/t,.5)+9.5))))+Math.floor(Math.max(0,Math.min(18,Math.floor(9*C(e[2]/t,.5)+9.5)))))(e,o),2)})),d};async function z(e){const t=window.URL.createObjectURL(e);try{const e=await function(e){return new Promise(((t,a)=>{const i=new window.Image;i.src=e,i.onload=()=>t(i),i.onerror=a}))}(t),a=document.createElement("canvas"),{width:i,height:l}=function(e,t){const a=Math.abs(Math.min(Math.min(120/e,120/t),1)-1);return{width:Math.floor(e-a*e),height:Math.floor(t-a*t)}}(e.width,e.height);a.width=i,a.height=l;const s=a.getContext("2d");if(!s)throw new Error("Could not get 2d canvas context!");s.drawImage(e,0,0,i,l);const o=s.getImageData(0,0,i,l);return{blurhash:P(o.data,o.width,o.height,4,4),width:e.width,height:e.height}}catch(e){return}finally{window.URL.revokeObjectURL(t)}}var L=a(770);class SimpleStateSubject extends $.BehaviorSubject{constructor(e){super(e)}getSnapshot(){return this.getValue()}setState(e){this.next((0,L.merge)({},this.getSnapshot(),e))}}class UploadState{constructor(e,t,a={allowRepeatedUploads:!1},i=z){(0,j.default)(this,"abort$",new $.Subject),(0,j.default)(this,"files$$",new $.BehaviorSubject([])),(0,j.default)(this,"files$",this.files$$.pipe($.switchMap((e=>e.length?$.zip(...e):$.of([]))))),(0,j.default)(this,"clear$",new $.Subject),(0,j.default)(this,"error$",new $.BehaviorSubject(void 0)),(0,j.default)(this,"uploading$",new $.BehaviorSubject(!1)),(0,j.default)(this,"done$",new $.Subject),(0,j.default)(this,"subscriptions",void 0),(0,j.default)(this,"validateFile",(e=>{const t=this.fileKind;if(!e.size)throw new Error(p.fileEmpty);if(null!=t.maxSizeBytes&&e.size>this.fileKind.maxSizeBytes){const e=p.fileTooLarge(String(this.fileKind.maxSizeBytes));throw new Error(e)}if(null!=t.allowedMimeTypes&&!t.allowedMimeTypes.includes(e.type)){const a=p.mimeTypeNotSupported(e.type,t.allowedMimeTypes.join(", "));throw new Error(a)}})),(0,j.default)(this,"setFiles",(e=>{if(this.isUploading())throw new Error("Cannot update files while uploading");let t;e.length||(this.done$.next(void 0),this.error$.next(void 0));try{e.forEach(this.validateFile)}catch(e){t=e}this.files$$.next(e.map((e=>new SimpleStateSubject({file:e,status:"idle",error:t}))))})),(0,j.default)(this,"abort",(()=>{if(!this.isUploading())throw new Error("No upload in progress");this.abort$.next()})),(0,j.default)(this,"clear",(()=>{this.setFiles([]),this.clear$.next()})),(0,j.default)(this,"uploadFile",((e,t,a)=>{const i=new AbortController,l=i.signal,{file:s,status:o,error:r}=e.getValue();if(r&&"idle"===o)return $.of(void 0);if(!["idle","upload_failed"].includes(o))return $.of(void 0);let n;e.setState({status:"uploading",error:void 0});const{name:d}={name:((u=s.name).substring(0,u.lastIndexOf("."))||u).trim().slice(0,256).replace(/[^a-z0-9\s]/gi,"_")};var u;const c=s.type||void 0,p=a;return $.from(function(e){var t;return Boolean(null===(t=e.type)||void 0===t?void 0:t.startsWith("image/"))}(s)?this.loadImageMetadata(s):$.of(void 0)).pipe($.mergeMap((e=>this.client.create({kind:this.fileKind.id,name:d,mimeType:c,meta:e?{...e,...p}:p}))),$.mergeMap((e=>(n=e.file,$.race(t.pipe($.map((()=>{throw i.abort(),new Error("Abort!")}))),this.client.upload({body:s,id:n.id,kind:this.fileKind.id,abortSignal:l,selfDestructOnAbort:!0,contentType:c}))))),$.map((()=>{var t;e.setState({status:"uploaded",id:null===(t=n)||void 0===t?void 0:t.id,fileJSON:n})})),$.catchError((t=>{const a="Abort!"===t.message;return e.setState({status:"upload_failed",error:a?void 0:t}),$.of(a?void 0:t)})))})),(0,j.default)(this,"upload",(e=>{if(this.isUploading())throw new Error("Upload already in progress");const t=new $.ReplaySubject(1),a=this.abort$.subscribe(t),i=this.files$$.pipe($.take(1),$.switchMap((a=>$.forkJoin(a.map((a=>this.uploadFile(a,t,e)))))),$.map((()=>{})),$.finalize((()=>{this.opts.allowRepeatedUploads&&this.clear(),a.unsubscribe()})),$.shareReplay());return i.subscribe(),i})),(0,j.default)(this,"dispose",(()=>{for(const e of this.subscriptions)e.unsubscribe()})),this.fileKind=e,this.client=t,this.opts=a,this.loadImageMetadata=i;const l=this.files$$.pipe($.switchMap((e=>$.combineLatest(e))));this.subscriptions=[l.pipe($.map((e=>e.some((e=>"uploading"===e.status)))),$.distinctUntilChanged()).subscribe(this.uploading$),l.pipe($.map((e=>{const t=e.find((e=>Boolean(e.error)));return t?t.error:void 0})),$.filter(Boolean)).subscribe(this.error$),l.pipe($.filter((e=>Boolean(e.length)&&e.every((e=>"uploaded"===e.status)))),$.map((e=>e.map((e=>({id:e.id,kind:this.fileKind.id,fileJSON:e.fileJSON})))))).subscribe(this.done$)]}isUploading(){return this.uploading$.getValue()}hasFiles(){return this.files$$.getValue().length>0}}const I=({meta:e,onDone:t,onError:a,fullWidth:l,allowClear:o,onUploadEnd:r,onUploadStart:n,compressed:d=!1,kind:c,multiple:p=!1,initialPromptText:f,immediate:m=!1,allowRepeatedUploads:g=!1,className:b})=>{var w;const{client:M}=(0,s.A)(),x=(0,i.useRef)(null),v=M.getFileKind(c),y=d||g,j=(0,i.useMemo)((()=>(({fileKind:e,client:t,imageMetadataFactory:a,...i})=>new UploadState(e,t,i,a))({client:M,fileKind:v,allowRepeatedUploads:y})),[M,y,v]);return(0,i.useEffect)((()=>{const e=[j.clear$.subscribe((()=>{var e;null===(e=x.current)||void 0===e||e.removeFiles()})),j.done$.subscribe((e=>e&&t(e))),j.error$.subscribe((e=>e&&(null==a?void 0:a(e)))),j.uploading$.subscribe((e=>e?null==n?void 0:n():null==r?void 0:r()))];return()=>e.forEach((e=>e.unsubscribe()))}),[j,t,a,n,r]),(0,i.useEffect)((()=>j.dispose),[j]),(0,u.jsx)(h.Provider,{value:j},(0,u.jsx)(U,{compressed:d,ref:x,accept:null===(w=v.allowedMimeTypes)||void 0===w?void 0:w.join(","),meta:e,immediate:d||m,allowClear:o,fullWidth:l,initialFilePromptText:f,multiple:p,className:b}))},R=I}}]);