"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../common/constants");
var _custom_fields_list = require("./custom_fields_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldsComponent = ({
  disabled,
  isLoading,
  handleAddCustomField,
  handleDeleteCustomField,
  handleEditCustomField,
  customFields
}) => {
  const [error, setError] = (0, _react.useState)(false);
  const onAddCustomField = (0, _react.useCallback)(() => {
    if (customFields.length === _constants.MAX_CUSTOM_FIELDS_PER_CASE && !error) {
      setError(true);
      return;
    }
    handleAddCustomField();
    setError(false);
  }, [handleAddCustomField, setError, customFields, error]);
  const onEditCustomField = (0, _react.useCallback)(key => {
    setError(false);
    handleEditCustomField(key);
  }, [setError, handleEditCustomField]);
  if (customFields.length < _constants.MAX_CUSTOM_FIELDS_PER_CASE && error) {
    setError(false);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.TITLE),
    description: /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION),
    "data-test-subj": "custom-fields-form-group",
    css: {
      alignItems: 'flex-start'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: false,
    hasShadow: false
  }, customFields.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_custom_fields_list.CustomFieldsList, {
    customFields: customFields,
    onDeleteCustomField: handleDeleteCustomField,
    onEditCustomField: onEditCustomField
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !customFields.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "empty-custom-fields"
  }, i18n.NO_CUSTOM_FIELDS, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, customFields.length < _constants.MAX_CUSTOM_FIELDS_PER_CASE ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isLoading,
    isDisabled: disabled || error,
    size: "s",
    onClick: onAddCustomField,
    iconType: "plusInCircle",
    "data-test-subj": "add-custom-field"
  }, i18n.ADD_CUSTOM_FIELD) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.MAX_CUSTOM_FIELD_LIMIT(_constants.MAX_CUSTOM_FIELDS_PER_CASE)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })));
};
CustomFieldsComponent.displayName = 'CustomFields';
const CustomFields = exports.CustomFields = /*#__PURE__*/_react.default.memo(CustomFieldsComponent);