"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransaction = getTransaction;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe = require("../../../../common/utils/maybe");
var _apm = require("../../../../common/es_fields/apm");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTransaction({
  transactionId,
  traceId,
  apmEventClient,
  start,
  end
}) {
  var _event$server, _event$server2, _source$transaction;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.TRACE_ID, _apm.AGENT_NAME, _apm.PROCESSOR_EVENT, _apm.AT_TIMESTAMP, _apm.TIMESTAMP_US, _apm.SERVICE_NAME, _apm.TRANSACTION_ID, _apm.TRANSACTION_DURATION, _apm.TRANSACTION_NAME, _apm.TRANSACTION_SAMPLED, _apm.TRANSACTION_TYPE]);
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.PROCESSOR_NAME, _apm.SERVICE_LANGUAGE_NAME, _apm.URL_FULL, _apm.TRANSACTION_PAGE_URL, _apm.HTTP_RESPONSE_STATUS_CODE, _apm.HTTP_REQUEST_METHOD, _apm.USER_AGENT_NAME, _apm.URL_PATH, _apm.URL_SCHEME, _apm.SERVER_ADDRESS, _apm.SERVER_PORT, _apm.USER_AGENT_VERSION]);
  const resp = await apmEventClient.search('get_transaction', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 1,
      terminate_after: 1,
      query: {
        bool: {
          filter: (0, _as_mutable_array.asMutableArray)([{
            term: {
              [_apm.TRANSACTION_ID]: transactionId
            }
          }, ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.rangeQuery)(start, end)])
        }
      },
      fields: [...requiredFields, ...optionalFields],
      _source: [_apm.SPAN_LINKS, _apm.TRANSACTION_MARKS_AGENT]
    }
  });
  const hit = (0, _maybe.maybe)(resp.hits.hits[0]);
  if (!hit) {
    return undefined;
  }
  const event = (0, _utils.unflattenKnownApmEventFields)(hit.fields, requiredFields);
  const source = 'span' in hit._source || 'transaction' in hit._source ? hit._source : undefined;
  return {
    ...event,
    server: {
      ...event.server,
      port: (_event$server = event.server) !== null && _event$server !== void 0 && _event$server.port ? Number((_event$server2 = event.server) === null || _event$server2 === void 0 ? void 0 : _event$server2.port) : undefined
    },
    transaction: {
      ...event.transaction,
      marks: source === null || source === void 0 ? void 0 : (_source$transaction = source.transaction) === null || _source$transaction === void 0 ? void 0 : _source$transaction.marks
    },
    processor: {
      name: 'transaction',
      event: 'transaction'
    },
    span: source === null || source === void 0 ? void 0 : source.span
  };
}