"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorAdapterRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConnectorAdapterRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "connectorAdapters", new Map());
  }
  has(connectorTypeId) {
    return this.connectorAdapters.has(connectorTypeId);
  }
  register(connectorAdapter) {
    if (this.has(connectorAdapter.connectorTypeId)) {
      throw new Error(`${connectorAdapter.connectorTypeId} is already registered to the ConnectorAdapterRegistry`);
    }
    this.connectorAdapters.set(connectorAdapter.connectorTypeId, connectorAdapter);
  }
  get(connectorTypeId) {
    if (!this.connectorAdapters.has(connectorTypeId)) {
      throw _boom.default.badRequest(_i18n.i18n.translate('xpack.alerting.connectorAdapterRegistry.get.missingConnectorAdapterErrorMessage', {
        defaultMessage: 'Connector adapter "{connectorTypeId}" is not registered.',
        values: {
          connectorTypeId
        }
      }));
    }
    return this.connectorAdapters.get(connectorTypeId);
  }
}
exports.ConnectorAdapterRegistry = ConnectorAdapterRegistry;