"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeChangePointControls = exports.changePointComparators = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const changePointComparators = exports.changePointComparators = {
  viewType: 'referenceEquality',
  dataViewId: 'referenceEquality',
  fn: 'referenceEquality',
  metricField: 'referenceEquality',
  splitField: 'referenceEquality',
  partitions: 'deepEquality',
  maxSeriesToPlot: 'referenceEquality'
};
const initializeChangePointControls = rawState => {
  const viewType = new _rxjs.BehaviorSubject(rawState.viewType);
  const dataViewId = new _rxjs.BehaviorSubject(rawState.dataViewId);
  const fn = new _rxjs.BehaviorSubject(rawState.fn);
  const metricField = new _rxjs.BehaviorSubject(rawState.metricField);
  const splitField = new _rxjs.BehaviorSubject(rawState.splitField);
  const partitions = new _rxjs.BehaviorSubject(rawState.partitions);
  const maxSeriesToPlot = new _rxjs.BehaviorSubject(rawState.maxSeriesToPlot);
  const updateUserInput = update => {
    viewType.next(update.viewType);
    dataViewId.next(update.dataViewId);
    fn.next(update.fn);
    metricField.next(update.metricField);
    splitField.next(update.splitField);
    partitions.next(update.partitions);
    maxSeriesToPlot.next(update.maxSeriesToPlot);
  };
  const getLatestState = () => {
    return {
      viewType: viewType.getValue(),
      dataViewId: dataViewId.getValue(),
      fn: fn.getValue(),
      metricField: metricField.getValue(),
      splitField: splitField.getValue(),
      partitions: partitions.getValue(),
      maxSeriesToPlot: maxSeriesToPlot.getValue()
    };
  };
  return {
    api: {
      viewType,
      dataViewId,
      fn,
      metricField,
      splitField,
      partitions,
      maxSeriesToPlot,
      updateUserInput
    },
    anyStateChange$: (0, _rxjs.merge)(viewType, dataViewId, fn, metricField, splitField, partitions, maxSeriesToPlot).pipe((0, _rxjs.map)(() => undefined)),
    getLatestState,
    reinitializeState: lastSavedState => {
      viewType.next(lastSavedState.viewType);
      dataViewId.next(lastSavedState.dataViewId);
      fn.next(lastSavedState.fn);
      metricField.next(lastSavedState.metricField);
      splitField.next(lastSavedState.splitField);
      partitions.next(lastSavedState.partitions);
      maxSeriesToPlot.next(lastSavedState.maxSeriesToPlot);
    }
  };
};
exports.initializeChangePointControls = initializeChangePointControls;