"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidationStep = exports.isResultStep = exports.isFilePickerStep = exports.getStepStatus = exports.formatTimeFromNow = exports.buildAnnotationsFromError = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStepStatus = (step, currentStep) => {
  if (step < _types.FileUploaderSteps.RESULT && currentStep === _types.FileUploaderSteps.RESULT) {
    return 'disabled';
  }
  if (currentStep === step) {
    return 'current';
  }
  if (currentStep > step) {
    return 'complete';
  }
  return 'disabled';
};
exports.getStepStatus = getStepStatus;
const isFilePickerStep = state => state.step === _types.FileUploaderSteps.FILE_PICKER;
exports.isFilePickerStep = isFilePickerStep;
const isValidationStep = state => state.step === _types.FileUploaderSteps.VALIDATION;
exports.isValidationStep = isValidationStep;
const isResultStep = state => state.step === _types.FileUploaderSteps.RESULT;
exports.isResultStep = isResultStep;
const buildAnnotationsFromError = errors => {
  const annotations = {};
  errors.forEach(e => {
    annotations[e.index] = e.message;
  });
  return annotations;
};
exports.buildAnnotationsFromError = buildAnnotationsFromError;
const formatTimeFromNow = time => {
  if (!time) {
    return '';
  }
  const scheduleTime = (0, _moment.default)(time);
  return scheduleTime.fromNow(true);
};
exports.formatTimeFromNow = formatTimeFromNow;