"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartSettingsPopoverConfiguration = void 0;
var _react = require("react");
var _use_inspect = require("../../../../../../../common/components/inspect/use_inspect");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultInitialPanelId = 'default-initial-panel';
const useChartSettingsPopoverConfiguration = ({
  onResetStackByFields,
  queryId
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    handleClick
  } = (0, _use_inspect.useInspect)({
    queryId
  });
  const defaultMenuItems = (0, _react.useMemo)(() => [{
    id: defaultInitialPanelId,
    items: [{
      icon: 'inspect',
      name: i18n.INSPECT,
      onClick: () => {
        setIsPopoverOpen(false);
        handleClick();
      }
    }, {
      name: i18n.RESET_GROUP_BY_FIELDS,
      onClick: () => {
        setIsPopoverOpen(false);
        onResetStackByFields();
      }
    }]
  }], [handleClick, onResetStackByFields]);
  return {
    defaultInitialPanelId,
    defaultMenuItems,
    isPopoverOpen,
    setIsPopoverOpen
  };
};
exports.useChartSettingsPopoverConfiguration = useChartSettingsPopoverConfiguration;