"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasOptionalStackByField = exports.getUpToMaxBuckets = exports.getMaxRiskSubAggregations = exports.getGroupByFieldsOnClick = void 0;
var _ecs_safety_helpers = require("../../../../../../../common/endpoint/models/ecs_safety_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUpToMaxBuckets = ({
  buckets,
  maxItems
}) => {
  var _buckets$slice;
  return (_buckets$slice = buckets === null || buckets === void 0 ? void 0 : buckets.slice(0, maxItems)) !== null && _buckets$slice !== void 0 ? _buckets$slice : [];
};
exports.getUpToMaxBuckets = getUpToMaxBuckets;
const getMaxRiskSubAggregations = buckets => buckets.reduce((acc, x) => {
  var _firstNonNullValue, _x$maxRiskSubAggregat, _x$maxRiskSubAggregat2;
  return {
    ...acc,
    [(_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)(x.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '']: (_x$maxRiskSubAggregat = (_x$maxRiskSubAggregat2 = x.maxRiskSubAggregation) === null || _x$maxRiskSubAggregat2 === void 0 ? void 0 : _x$maxRiskSubAggregat2.value) !== null && _x$maxRiskSubAggregat !== void 0 ? _x$maxRiskSubAggregat : undefined
  };
}, {});
exports.getMaxRiskSubAggregations = getMaxRiskSubAggregations;
const getGroupByFieldsOnClick = elements => {
  const flattened = elements.flat(2);
  const groupByField0 = flattened.length > 0 && 'groupByRollup' in flattened[0] && flattened[0].groupByRollup != null ? `${flattened[0].groupByRollup}` : '';
  const groupByField1 = flattened.length > 1 && 'groupByRollup' in flattened[1] && flattened[1].groupByRollup != null ? `${flattened[1].groupByRollup}` : '';
  return {
    groupByField0,
    groupByField1
  };
};
exports.getGroupByFieldsOnClick = getGroupByFieldsOnClick;
const hasOptionalStackByField = stackByField1 => stackByField1 != null && stackByField1.trim() !== '';
exports.hasOptionalStackByField = hasOptionalStackByField;