"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewFiltersPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _dashboard_legend = require("./shared_components/dashboard_legend");
var i18n = _interopRequireWildcard(require("./translations"));
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
var _rule_activity_filter = require("./rule_activity_filter");
var _rule_source_filter = require("./rule_source_filter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewFiltersPanelComponent = () => {
  var _filter$activity, _filter$source;
  const {
    state: {
      filter,
      isLoading,
      showExpandedCells
    },
    actions: {
      setShowExpandedCells,
      setRuleActivityFilter,
      setRuleSourceFilter,
      setRuleSearchFilter
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  const handleExpandCellsFilterClick = () => setShowExpandedCells(true);
  const handleCollapseCellsFilterClick = () => setShowExpandedCells(false);
  const handleRuleSearchOnChange = (0, _react.useCallback)(({
    queryText
  }) => {
    setRuleSearchFilter(queryText);
  }, [setRuleSearchFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _css.css)`
              flex-grow: 0;
            `
  }, /*#__PURE__*/_react.default.createElement(_rule_activity_filter.RuleActivityFilter, {
    onChange: setRuleActivityFilter,
    isLoading: isLoading,
    selected: (_filter$activity = filter.activity) !== null && _filter$activity !== void 0 ? _filter$activity : []
  }), /*#__PURE__*/_react.default.createElement(_rule_source_filter.RuleSourceFilter, {
    onChange: setRuleSourceFilter,
    isLoading: isLoading,
    selected: (_filter$source = filter.source) !== null && _filter$source !== void 0 ? _filter$source : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      placeholder: i18n.CoverageOverviewSearchBarPlaceholder,
      'data-test-subj': 'coverageOverviewFilterSearchBar'
    },
    onChange: handleRuleSearchOnChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    isToggle: true,
    isSelected: !showExpandedCells,
    hasActiveFilters: !showExpandedCells,
    onClick: handleCollapseCellsFilterClick
  }, i18n.COLLAPSE_CELLS_FILTER_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showExpandedCells,
    hasActiveFilters: showExpandedCells,
    onClick: handleExpandCellsFilterClick
  }, i18n.EXPAND_CELLS_FILTER_BUTTON))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_dashboard_legend.CoverageOverviewLegend, null))));
};
const CoverageOverviewFiltersPanel = exports.CoverageOverviewFiltersPanel = /*#__PURE__*/(0, _react.memo)(CoverageOverviewFiltersPanelComponent);