"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewTermsRuleFieldEdit = NewTermsRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _alert_suppression = require("./fields/alert_suppression");
var _data_source = require("./fields/data_source");
var _history_window_start_edit_form = require("./fields/history_window_start/history_window_start_edit_form");
var _kql_query = require("./fields/kql_query");
var _new_terms_fields_edit_form = require("./fields/new_terms_fields/new_terms_fields_edit_form");
var _utility_types = require("../../../../../../../common/utility_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NewTermsRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionEditForm, null);
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceEditForm, null);
    case 'history_window_start':
      return /*#__PURE__*/_react.default.createElement(_history_window_start_edit_form.HistoryWindowStartEditForm, null);
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryEditForm, null);
    case 'new_terms_fields':
      return /*#__PURE__*/_react.default.createElement(_new_terms_fields_edit_form.NewTermsFieldsEditForm, null);
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}