"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchQueryEditAdapter = ThreatMatchQueryEditAdapter;
var _react = _interopRequireDefault(require("react"));
var _threat_match_query_edit = require("../../../../../../../rule_creation/components/threat_match_query_edit");
var _use_data_view = require("../hooks/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThreatMatchQueryEditAdapter({
  finalDiffableRule
}) {
  var _threat_index;
  const {
    dataView,
    isLoading
  } = (0, _use_data_view.useDataView)({
    indexPatterns: (_threat_index = finalDiffableRule.threat_index) !== null && _threat_index !== void 0 ? _threat_index : []
  });
  return /*#__PURE__*/_react.default.createElement(_threat_match_query_edit.ThreatMatchQueryEdit, {
    path: "threatQuery",
    threatIndexPatterns: dataView !== null && dataView !== void 0 ? dataView : DEFAULT_DATA_VIEW,
    loading: isLoading
  });
}
const DEFAULT_DATA_VIEW = {
  fields: [],
  title: ''
};