"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleScheduleSection = exports.AccessibleTimeValue = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _date_math = require("@kbn/securitysolution-utils/date_math");
var _to_simple_rule_schedule = require("../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
var _accessibility = require("../../../../common/components/accessibility");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_field_name = require("./rule_field_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccessibleTimeValue = ({
  timeValue,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_accessibility.IntervalAbbrScreenReader, {
  interval: timeValue
}));
exports.AccessibleTimeValue = AccessibleTimeValue;
const Interval = ({
  interval
}) => /*#__PURE__*/_react.default.createElement(AccessibleTimeValue, {
  timeValue: interval,
  "data-test-subj": "intervalPropertyValue"
});
const LookBack = ({
  value
}) => /*#__PURE__*/_react.default.createElement(AccessibleTimeValue, {
  timeValue: value,
  "data-test-subj": `lookBackPropertyValue-${value}`
});
const RuleScheduleSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  ...descriptionListProps
}) => {
  var _rule$to, _descriptionListProps, _descriptionListProps2;
  if (!rule.interval || !rule.from) {
    return null;
  }
  const to = (_rule$to = rule.to) !== null && _rule$to !== void 0 ? _rule$to : 'now';
  const simpleRuleSchedule = (0, _to_simple_rule_schedule.toSimpleRuleSchedule)({
    interval: rule.interval,
    from: rule.from,
    to
  });
  const ruleSectionListItems = !simpleRuleSchedule ? [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle"
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.INTERVAL_FIELD_LABEL,
      fieldName: "rule_schedule"
    })),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: rule.interval
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromToPropertyTitle"
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.RULE_SOURCE_EVENTS_TIME_RANGE_FIELD_LABEL,
      fieldName: "rule_schedule"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromToPropertyValue"
    }, i18n.RULE_SOURCE_EVENTS_TIME_RANGE((0, _date_math.normalizeDateMath)(rule.from), (0, _date_math.normalizeDateMath)(to)))
  }] : [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle"
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.INTERVAL_FIELD_LABEL,
      fieldName: "rule_schedule"
    })),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: simpleRuleSchedule.interval
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "lookBackPropertyTitle"
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.LOOK_BACK_FIELD_LABEL,
      fieldName: "rule_schedule"
    })),
    description: /*#__PURE__*/_react.default.createElement(LookBack, {
      value: simpleRuleSchedule.lookback
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: ruleSectionListItems,
    columnWidths: columnWidths
  }, descriptionListProps)));
};
exports.RuleScheduleSection = RuleScheduleSection;