"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_VALUE_VALIDATION_ERROR = exports.THRESHOLD_VALUE_LABEL = exports.THRESHOLD_FIELD_LABEL = exports.THRESHOLD_FIELD_HELP_TEXT = exports.THRESHOLD_FIELD_COUNT_VALIDATION_ERROR = exports.CARDINALITY_VALUE_VALIDATION_ERROR = exports.CARDINALITY_VALUE_LABEL = exports.CARDINALITY_FIELD_MISSING_VALIDATION_ERROR = exports.CARDINALITY_FIELD_LABEL = exports.CARDINALITY_FIELD_HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THRESHOLD_FIELD_LABEL = exports.THRESHOLD_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdFieldLabel', {
  defaultMessage: 'Group by'
});
const THRESHOLD_FIELD_HELP_TEXT = exports.THRESHOLD_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdFieldHelpText', {
  defaultMessage: "Select fields to group by. Fields are joined together with 'AND'"
});
const THRESHOLD_FIELD_COUNT_VALIDATION_ERROR = exports.THRESHOLD_FIELD_COUNT_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdFieldFieldData.arrayLengthGreaterThanMaxErrorMessage', {
  defaultMessage: 'Number of fields must be 3 or less.'
});
const THRESHOLD_VALUE_LABEL = exports.THRESHOLD_VALUE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdValueLabel', {
  defaultMessage: 'Threshold'
});
const THRESHOLD_VALUE_VALIDATION_ERROR = exports.THRESHOLD_VALUE_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdValueFieldData.numberGreaterThanOrEqualOneErrorMessage', {
  defaultMessage: 'Value must be greater than or equal to one.'
});
const CARDINALITY_FIELD_LABEL = exports.CARDINALITY_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdCardinalityFieldLabel', {
  defaultMessage: 'Count'
});
const CARDINALITY_FIELD_MISSING_VALIDATION_ERROR = exports.CARDINALITY_FIELD_MISSING_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdCardinalityFieldFieldData.thresholdCardinalityFieldNotSuppliedMessage', {
  defaultMessage: 'A Cardinality Field is required.'
});
const CARDINALITY_FIELD_HELP_TEXT = exports.CARDINALITY_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdFieldCardinalityFieldHelpText', {
  defaultMessage: 'Select a field to check cardinality'
});
const CARDINALITY_VALUE_LABEL = exports.CARDINALITY_VALUE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdCardinalityValueFieldLabel', {
  defaultMessage: 'Unique values'
});
const CARDINALITY_VALUE_VALIDATION_ERROR = exports.CARDINALITY_VALUE_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdCardinalityValueFieldData.numberGreaterThanOrEqualOneErrorMessage', {
  defaultMessage: 'Value must be greater than or equal to one.'
});