"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlUserJobDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _noop = _interopRequireDefault(require("lodash/noop"));
var i18n = _interopRequireWildcard(require("../translations"));
var _helpers = require("../../../../../../common/machine_learning/helpers");
var _ml_job_item = require("../ml_job_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlUserJobDescriptionComponent = ({
  job
}) => {
  const switchComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.ML_ADMIN_REQUIRED
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: true,
    "data-test-subj": "mlUserJobSwitch",
    showLabel: false,
    label: "",
    checked: (0, _helpers.isJobStarted)(job.jobState, job.datafeedState),
    onChange: _noop.default
  })), [job]);
  return /*#__PURE__*/_react.default.createElement(_ml_job_item.MlJobItem, {
    job: job,
    switchComponent: switchComponent
  });
};
const MlUserJobDescription = exports.MlUserJobDescription = /*#__PURE__*/(0, _react.memo)(MlUserJobDescriptionComponent);