"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnomaliesTableData = exports.influencersOrCriteriaToString = exports.getThreshold = void 0;
var _react = require("react");
var _constants = require("../../../../../common/constants");
var _anomalies_table_data = require("../api/anomalies_table_data");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../lib/kibana");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _use_fetch = require("../../../hooks/use_fetch");
var _use_ml_capabilities = require("../hooks/use_ml_capabilities");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const influencersOrCriteriaToString = influencers => influencers == null ? '' : influencers.reduce((accum, item) => `${accum}${item.fieldName}:${item.fieldValue}`, '');
exports.influencersOrCriteriaToString = influencersOrCriteriaToString;
const getThreshold = (anomalyScore, threshold) => {
  if (threshold !== -1) {
    return threshold;
  } else if (anomalyScore == null) {
    return 50;
  } else if (anomalyScore < 0) {
    return 0;
  } else if (anomalyScore > 100) {
    return 100;
  } else {
    return Math.floor(anomalyScore);
  }
};
exports.getThreshold = getThreshold;
const useAnomaliesTableData = ({
  criteriaFields = [],
  influencers = [],
  startDate,
  endDate,
  threshold = -1,
  skip = false,
  filterQuery,
  jobIds,
  aggregationInterval
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const isMlUser = (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const timeZone = (0, _kibana.useTimeZone)();
  const [anomalyScore] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_ANOMALY_SCORE);
  const startDateMs = (0, _react.useMemo)(() => new Date(startDate).getTime(), [startDate]);
  const endDateMs = (0, _react.useMemo)(() => new Date(endDate).getTime(), [endDate]);
  const {
    fetch,
    data = null,
    isLoading,
    error
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.ANOMALIES_TABLE, _anomalies_table_data.anomaliesTableData, {
    disabled: skip
  });
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.SIEM_TABLE_FETCH_FAILURE
      });
    }
  }, [error, addError]);
  (0, _react.useEffect)(() => {
    if (isMlUser && jobIds.length > 0) {
      fetch({
        jobIds,
        criteriaFields,
        influencersFilterQuery: filterQuery,
        aggregationInterval,
        threshold: getThreshold(anomalyScore, threshold),
        earliestMs: startDateMs,
        latestMs: endDateMs,
        influencers,
        dateFormatTz: timeZone,
        maxRecords: 500,
        maxExamples: 10
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [
  // eslint-disable-next-line react-hooks/exhaustive-deps
  influencersOrCriteriaToString(influencers),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  influencersOrCriteriaToString(criteriaFields), startDateMs, endDateMs, isMlUser, aggregationInterval,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  jobIds.sort().join()]);
  return [isLoading, data];
};
exports.useAnomaliesTableData = useAnomaliesTableData;