"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointUnisolateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _missing_encryption_key_callout = require("../../../../management/components/missing_encryption_key_callout");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointUnisolateForm = exports.EndpointUnisolateForm = /*#__PURE__*/(0, _react.memo)(({
  hostName,
  onCancel,
  onConfirm,
  onChange,
  comment = '',
  messageAppend,
  isLoading = false
}) => {
  const handleCommentChange = (0, _react.useCallback)(event => {
    onChange({
      comment: event.target.value
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_encryption_key_callout.MissingEncryptionKeyCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "endpointHostIsolationForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolation.unIsolateThisHost",
    defaultMessage: "{hostName} is currently {isolated}. Are you sure you want to {unisolate} this host?",
    values: {
      hostName: /*#__PURE__*/_react.default.createElement("b", null, hostName),
      isolated: /*#__PURE__*/_react.default.createElement("b", null, _translations.ISOLATED),
      unisolate: /*#__PURE__*/_react.default.createElement("b", null, _translations.UNISOLATE)
    }
  }), ' ', messageAppend))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.COMMENT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "host_isolation_comment",
    fullWidth: true,
    placeholder: _translations.COMMENT_PLACEHOLDER,
    value: comment,
    onChange: handleCommentChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    disabled: isLoading,
    "data-test-subj": "hostIsolateCancelButton"
  }, _translations.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onConfirm,
    disabled: isLoading,
    isLoading: isLoading
  }, _translations.CONFIRM))))));
});
EndpointUnisolateForm.displayName = 'EndpointUnisolateForm';