"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunScriptActionRequestSchema = exports.MSDefenderEndpointRunScriptActionRequestSchema = exports.MSDefenderEndpointRunScriptActionRequestParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _base = require("../../common/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  parameters,
  ...restBaseSchema
} = _base.BaseActionRequestSchema;
const getNonEmptyString = fieldName => _configSchema.schema.string({
  minLength: 1,
  validate: value => {
    if (!value.trim().length) {
      return `${fieldName} cannot be an empty string`;
    }
  }
});

// CrowdStrike schemas
const CrowdStrikeRunScriptActionRequestParamsSchema = _configSchema.schema.object({
  /**
   * The script to run
   */
  raw: _configSchema.schema.maybe(getNonEmptyString('Raw')),
  /**
   * The path to the script on the host to run
   */
  hostPath: _configSchema.schema.maybe(getNonEmptyString('HostPath')),
  /**
   * The path to the script in the cloud to run
   */
  cloudFile: _configSchema.schema.maybe(getNonEmptyString('CloudFile')),
  /**
   * The command line to run
   */
  commandLine: _configSchema.schema.maybe(getNonEmptyString('CommandLine')),
  /**
   * The max timeout value before the command is killed. Number represents milliseconds
   */
  timeout: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1
  }))
}, {
  validate: params => {
    if (!params.raw && !params.hostPath && !params.cloudFile) {
      return 'At least one of Raw, HostPath, or CloudFile must be provided';
    }
  }
});

// Microsoft Defender Endpoint schemas
const MSDefenderEndpointRunScriptActionRequestParamsSchema = exports.MSDefenderEndpointRunScriptActionRequestParamsSchema = _configSchema.schema.object({
  /**
   * The path to the script in the cloud to run
   */
  scriptName: getNonEmptyString('ScriptName'),
  args: _configSchema.schema.maybe(getNonEmptyString('Args'))
});
const MSDefenderEndpointRunScriptActionRequestSchema = exports.MSDefenderEndpointRunScriptActionRequestSchema = {
  body: _configSchema.schema.object({
    ...restBaseSchema,
    parameters: MSDefenderEndpointRunScriptActionRequestParamsSchema
  })
};
const RunScriptActionRequestSchema = exports.RunScriptActionRequestSchema = {
  body: _configSchema.schema.object({
    ...restBaseSchema,
    parameters: _configSchema.schema.conditional(_configSchema.schema.siblingRef('agent_type'), 'crowdstrike', CrowdStrikeRunScriptActionRequestParamsSchema, _configSchema.schema.conditional(_configSchema.schema.siblingRef('agent_type'), 'microsoft_defender_endpoint', MSDefenderEndpointRunScriptActionRequestParamsSchema, _configSchema.schema.never()))
  })
};