"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightDetailsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lib = require("../../lib");
var _highlight_details_table = require("./highlight_details_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutEntry = ({
  title,
  body
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("dt", null, title), /*#__PURE__*/_react.default.createElement("dd", null, body));
const HighlightDetailsFlyout = ({
  indexName,
  operation,
  shardName,
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    className: "prfDevTool__details",
    onClose: () => onClose()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, indexName), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, shardName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.typeTitle', {
      defaultMessage: 'Type'
    }),
    body: operation.query_type
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "s"
    }, operation.lucene)
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.totalTimeTitle', {
      defaultMessage: 'Total time'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.totalTimeTooltip', {
        defaultMessage: 'The total time spent at this query component, inclusive of children'
      })
    })),
    body: (0, _lib.msToPretty)(operation.time, 3)
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.selfTimeTitle', {
      defaultMessage: 'Self time'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.selfTimeTooltip', {
        defaultMessage: 'The time spent by this query component alone, exclusive of children'
      })
    })),
    body: (0, _lib.msToPretty)(operation.selfTime || 0, 3)
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.timingBreakdownTitle', {
      defaultMessage: 'Timing breakdown'
    }),
    body: /*#__PURE__*/_react.default.createElement(_highlight_details_table.HighlightDetailsTable, {
      breakdown: operation.breakdown
    })
  })))));
};
exports.HighlightDetailsFlyout = HighlightDetailsFlyout;