"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSynonymsPlugin = void 0;
var _common = require("../common");
var _ui_flags = require("../common/ui_flags");
var _doc_links = require("../common/doc_links");
var _api_routes = require("../common/api_routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchSynonymsPlugin {
  constructor() {}
  setup(core, _) {
    if (!core.settings.client.get(_ui_flags.SYNONYMS_UI_FLAG, true)) {
      return {};
    }
    core.application.register({
      id: _common.PLUGIN_ID,
      appRoute: _api_routes.PLUGIN_ROUTE_ROOT,
      title: _common.PLUGIN_TITLE,
      deepLinks: [{
        id: 'synonyms',
        path: '/',
        title: _common.PLUGIN_TITLE,
        visibleIn: ['globalSearch']
      }],
      async mount({
        element,
        history
      }) {
        var _depsStart$searchNavi;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, depsStart] = await core.getStartServices();
        coreStart.chrome.docTitle.change(_common.PLUGIN_NAME);
        const startDeps = {
          ...depsStart,
          history
        };
        (_depsStart$searchNavi = depsStart.searchNavigation) === null || _depsStart$searchNavi === void 0 ? void 0 : _depsStart$searchNavi.handleOnAppMount();
        return renderApp(coreStart, startDeps, element);
      },
      visibleIn: []
    });
    return {};
  }
  start(core) {
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    return {};
  }
  stop() {}
}
exports.SearchSynonymsPlugin = SearchSynonymsPlugin;