"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleSearchResultsList = exports.QueryRuleSearchResults = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _query_rule_draggable_list_header = require("./query_rule_draggable_list_header");
var _query_rule_list_item_content = require("./query_rule_list_item_content");
var _styles = require("../styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRuleSearchResults = ({
  unfilteredRules,
  onEditRuleFlyoutOpen,
  deleteRule,
  queryRule,
  rulesetId
}) => {
  return /*#__PURE__*/_react.default.createElement(_query_rule_list_item_content.QueryRuleListItemContent, {
    rules: unfilteredRules,
    queryRule: queryRule,
    rulesetId: rulesetId,
    onEditRuleFlyoutOpen: onEditRuleFlyoutOpen,
    deleteRule: deleteRule
  });
};
exports.QueryRuleSearchResults = QueryRuleSearchResults;
const QueryRuleSearchResultsList = ({
  rules,
  unfilteredRules,
  rulesetId,
  onEditRuleFlyoutOpen,
  deleteRule,
  tourInfo
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_rule_draggable_list_header.QueryRuleDraggableListHeader, {
    tourInfo: tourInfo
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    css: (0, _styles.DroppableContainer)(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, rules.map((queryRule, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: queryRule.rule_id,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(QueryRuleSearchResults, {
    key: queryRule.rule_id,
    queryRule: queryRule,
    deleteRule: deleteRule,
    rulesetId: rulesetId,
    tourInfo: tourInfo,
    rules: rules,
    unfilteredRules: unfilteredRules,
    onEditRuleFlyoutOpen: onEditRuleFlyoutOpen,
    isLastItem: index === rules.length - 1
  }))))));
};
exports.QueryRuleSearchResultsList = QueryRuleSearchResultsList;