"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistClient = void 0;
exports.createAssist = createAssist;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AssistClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "options", void 0);
    (0, _defineProperty2.default)(this, "client", void 0);
    this.options = options;
    if ('es_client' in options) {
      this.client = options.es_client;
    } else {
      this.client = new _elasticsearch.Client({
        cloud: {
          id: this.options.cloud_id
        },
        auth: {
          apiKey: this.options.api_key
        }
      });
    }
  }
  getClient() {
    return this.client;
  }
}
exports.AssistClient = AssistClient;
function createAssist(options) {
  return new AssistClient(options);
}