"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostDetails = getHostDetails;
var _server = require("@kbn/observability-plugin/server");
var _profilingUtils = require("@kbn/profiling-utils");
var _storage_explorer = require("../../../common/storage_explorer");
var _get_daily_data_generation = require("./get_daily_data_generation.size");
var _get_indices_stats = require("./get_indices_stats");
var _get_profiling_hosts_details_by_id = require("./get_profiling_hosts_details_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const perIndexInitialSize = {
  events: 0,
  metrics: 0
};
async function getHostDetails({
  client,
  timeFrom,
  timeTo,
  kuery,
  indexLifecyclePhase
}) {
  var _response$aggregation, _response$aggregation2;
  const [{
    indices: allIndicesStats
  }, response] = await Promise.all([(0, _get_indices_stats.getIndicesStats)({
    client: client.getEsClient(),
    indices: _get_indices_stats.allIndices
  }), client.search('profiling_events_metrics_details', {
    index: ['profiling-events-*', 'profiling-metrics'],
    body: {
      query: {
        bool: {
          filter: [...(0, _server.kqlQuery)(kuery), {
            range: {
              [_profilingUtils.ProfilingESField.Timestamp]: {
                gte: String(timeFrom),
                lt: String(timeTo),
                format: 'epoch_second'
              }
            }
          }, ...(indexLifecyclePhase !== _storage_explorer.IndexLifecyclePhaseSelectOption.All ? (0, _server.termQuery)('_tier', _storage_explorer.indexLifeCyclePhaseToDataTier[indexLifecyclePhase]) : [])]
        }
      },
      aggs: {
        hosts: {
          terms: {
            field: _profilingUtils.ProfilingESField.HostID
          },
          aggs: {
            projectIds: {
              terms: {
                field: 'profiling.project.id'
              },
              aggs: {
                indices: {
                  terms: {
                    field: '_index',
                    size: 500
                  }
                }
              }
            }
          }
        }
      }
    }
  })]);
  const hostIds = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.hosts.buckets.map(bucket => bucket.key);
  const hostsDetailsMap = hostIds ? await (0, _get_profiling_hosts_details_by_id.getProfilingHostsDetailsById)({
    client,
    timeFrom,
    timeTo,
    kuery,
    hostIds
  }) : {};
  return ((_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.hosts.buckets.flatMap(bucket => {
    const hostId = bucket.key;
    const hostDetails = hostsDetailsMap[hostId];
    return bucket.projectIds.buckets.map(projectBucket => {
      var _hostDetails$probabil;
      const totalPerIndex = allIndicesStats ? projectBucket.indices.buckets.reduce((acc, indexBucket) => {
        const indexName = indexBucket.key;
        const estimatedSize = (0, _get_daily_data_generation.getEstimatedSizeForDocumentsInIndex)({
          allIndicesStats,
          indexName,
          numberOfDocs: indexBucket.doc_count
        });
        return {
          ...acc,
          ...(indexName.indexOf('metrics') > 0 ? {
            metrics: acc.metrics + estimatedSize
          } : {
            events: acc.events + estimatedSize
          })
        };
      }, perIndexInitialSize) : perIndexInitialSize;
      const projectId = projectBucket.key;
      const currentProjectProbabilisticValues = hostDetails === null || hostDetails === void 0 ? void 0 : (_hostDetails$probabil = hostDetails.probabilisticValuesPerProject) === null || _hostDetails$probabil === void 0 ? void 0 : _hostDetails$probabil[projectId];
      return {
        hostId,
        hostName: (hostDetails === null || hostDetails === void 0 ? void 0 : hostDetails.hostName) || '',
        probabilisticValues: (currentProjectProbabilisticValues === null || currentProjectProbabilisticValues === void 0 ? void 0 : currentProjectProbabilisticValues.probabilisticValues) || [],
        projectId,
        totalEventsSize: totalPerIndex.events,
        totalMetricsSize: totalPerIndex.metrics,
        totalSize: totalPerIndex.events + totalPerIndex.metrics
      };
    });
  })) || [];
}