"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Summary = Summary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _label_with_hint = require("../../components/label_with_hint");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _as_percentage = require("../../utils/formatters/as_percentage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Summary({
  data,
  isLoading
}) {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    kuery
  } = query;
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const summaryInfo = [{
    dataTestSubj: 'totalData',
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.totalData', {
      defaultMessage: 'Total data'
    }),
    value: data !== null && data !== void 0 && data.totalProfilingSizeBytes ? (0, _common.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.totalProfilingSizeBytes) : undefined,
    hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.totalData.hint', {
      defaultMessage: 'Total storage size of all Universal Profiling indices including replicas, ignoring the filter settings.'
    })
  }, {
    dataTestSubj: 'dailyDataGeneration',
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.dailyDataGeneration', {
      defaultMessage: 'Daily data generation'
    }),
    value: data !== null && data !== void 0 && data.dailyDataGenerationBytes ? (0, _common.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.dailyDataGenerationBytes) : undefined
  }, {
    dataTestSubj: 'totalDebugSymbolsSize',
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.totalDebugSymbolsSize', {
      defaultMessage: 'Total debug symbols size'
    }),
    value: data !== null && data !== void 0 && data.totalSymbolsSizeBytes ? (0, _common.asDynamicBytes)(data === null || data === void 0 ? void 0 : data.totalSymbolsSizeBytes) : undefined,
    hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.totalDebugSymbolsSize.hint', {
      defaultMessage: 'The total sum of private and public debug symbols.'
    })
  }, {
    dataTestSubj: 'diskSpaceUsed',
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.discSpaceUsed', {
      defaultMessage: 'Disk space used'
    }),
    value: data !== null && data !== void 0 && data.diskSpaceUsedPct ? (0, _as_percentage.asPercentage)(data === null || data === void 0 ? void 0 : data.diskSpaceUsedPct) : undefined,
    hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.discSpaceUsed.hint', {
      defaultMessage: 'The percentage of the storage capacity that is currently used by all of the Universal Profiling indices compared to the maximum storage capacity currently configured for Elasticsearch.'
    })
  }, {
    dataTestSubj: 'numberOfHostsAgents',
    title: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.numberOfHosts', {
      defaultMessage: 'Number of host agents'
    }),
    value: data === null || data === void 0 ? void 0 : data.totalNumberOfHosts,
    hint: _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.numberOfHosts.hint', {
      defaultMessage: 'Total number of Universal Profiling host agents reporting into the deployment.'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, summaryInfo.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: idx
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      description: item.hint ? /*#__PURE__*/_react.default.createElement(_label_with_hint.LabelWithHint, {
        label: item.title,
        hint: item.hint,
        labelSize: "xs"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, item.title),
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": item.dataTestSubj
      }, item.value),
      isLoading: isLoading
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "profilingSummaryGoToUniversalProfilingLink",
    href: profilingRouter.link('/stacktraces/{topNType}', {
      path: {
        topNType: _profilingUtils.TopNType.Hosts
      },
      query: {
        rangeFrom,
        rangeTo,
        kuery,
        limit: 10,
        displayAs: _profilingUtils.StackTracesDisplayOption.StackTraces
      }
    })
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.universalProfilingLink', {
    defaultMessage: 'Go to Universal Profiling'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "profilingSummaryGoToIndexManagementLink",
    href: core.http.basePath.prepend('/app/management/data/index_management/data_streams')
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.summary.indexManagement', {
    defaultMessage: 'Go to Index Management'
  })))))));
}