"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGrid = ChartGrid;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _subchart = require("./subchart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChartGrid({
  limit,
  charts,
  showFrames,
  onChartClick
}) {
  var _charts$length;
  const maximum = Math.min(limit, (_charts$length = charts.length) !== null && _charts$length !== void 0 ? _charts$length : 0);
  const ncharts = Math.min(maximum, charts.length);
  const subCharts = (0, _react.useMemo)(() => {
    return (0, _lodash.take)(charts, ncharts).map(subchart => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: subchart.Category
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
      index: subchart.Index,
      color: subchart.Color,
      category: subchart.Category,
      label: subchart.Label,
      percentage: subchart.Percentage,
      metadata: subchart.Metadata,
      height: 200,
      data: subchart.Series,
      sample: null,
      showAxes: true,
      onClick: onChartClick ? () => onChartClick(subchart) : undefined,
      showFrames: showFrames,
      padTitle: true
    }))));
  }, [charts, ncharts, onChartClick, showFrames]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "m"
  }, subCharts));
}