"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductInterceptPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _capitalize = _interopRequireDefault(require("lodash/capitalize"));
var _telemetry = require("./telemetry");
var _constants = require("../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ProductInterceptPublicPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.PromptTelemetry());
    (0, _defineProperty2.default)(this, "interceptSubscription", void 0);
    (0, _defineProperty2.default)(this, "upgradeInterceptSubscription", void 0);
    (0, _defineProperty2.default)(this, "trialInterceptSubscription", void 0);
    (0, _defineProperty2.default)(this, "buildVersion", void 0);
    this.buildVersion = ctx.env.packageInfo.version;
  }
  setup(core) {
    return this.telemetry.setup({
      analytics: core.analytics
    });
  }
  start(core, {
    intercepts,
    cloud
  }) {
    const eventReporter = this.telemetry.start({
      analytics: core.analytics
    });
    const productOffering = `Elastic ${(0, _capitalize.default)(cloud.serverless.projectType || '')}`.trim();
    void (async () => {
      const currentUser = await core.security.authc.getCurrentUser();
      const surveyUrl = new URL('https://ela.st/kibana-product-survey');
      surveyUrl.searchParams.set('uid', String(currentUser.profile_uid || null));
      surveyUrl.searchParams.set('pid', String(cloud.serverless.projectId || null));
      surveyUrl.searchParams.set('solution', String(cloud.serverless.projectType || null));
      [this.interceptSubscription, this.trialInterceptSubscription, this.upgradeInterceptSubscription] = [_constants.TRIGGER_DEF_ID, `${_constants.TRIAL_TRIGGER_DEF_ID}:${this.buildVersion}`, `${_constants.UPGRADE_TRIGGER_DEF_PREFIX_ID}:${this.buildVersion}`].map(triggerId => {
        var _intercepts$registerI;
        return (_intercepts$registerI = intercepts.registerIntercept) === null || _intercepts$registerI === void 0 ? void 0 : _intercepts$registerI.call(intercepts, {
          id: triggerId,
          config: () => Promise.resolve().then(() => _interopRequireWildcard(require('./intercept_registration_config'))).then(({
            productInterceptRegistrationConfig: registrationConfig
          }) => registrationConfig({
            productOffering,
            surveyUrl,
            eventReporter
          }))
        }).subscribe();
      });
    })();
    return {};
  }
  stop() {
    [this.interceptSubscription, this.trialInterceptSubscription, this.upgradeInterceptSubscription].forEach(subscription => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe());
  }
}
exports.ProductInterceptPublicPlugin = ProductInterceptPublicPlugin;