"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Main = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _format = require("../lib/format");
var _constants = require("../constants");
var _types = require("../types");
var _hooks = require("../hooks");
var _context = require("../context");
var _output_pane = require("./output_pane");
var _main_controls = require("./main_controls");
var _editor = require("./editor");
var _request_flyout = require("./request_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Main = () => {
  const {
    store: {
      payload,
      validation
    },
    updatePayload,
    services: {
      http
    },
    links
  } = (0, _context.useAppContext)();
  const [isRequestFlyoutOpen, setRequestFlyoutOpen] = (0, _react.useState)(false);
  const {
    inProgress,
    response,
    submit
  } = (0, _hooks.useSubmitCode)(http);

  // Live-update the output and persist payload state as the user changes it.
  (0, _react.useEffect)(() => {
    if (validation.isValid) {
      submit(payload);
    }
  }, [payload, submit, validation.isValid]);
  const toggleRequestFlyout = () => {
    setRequestFlyoutOpen(!isRequestFlyoutOpen);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "painlessLabMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "painlessLabPanelsContainer",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "painlessLabLeftPane"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "euiScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.painlessLab.title', {
    defaultMessage: 'Painless Lab'
  }))), /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    context: payload.context,
    code: payload.code,
    onChange: nextCode => updatePayload({
      code: nextCode
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_output_pane.OutputPane, {
    isLoading: inProgress,
    response: response
  }))), /*#__PURE__*/_react.default.createElement(_main_controls.MainControls, {
    links: links,
    isLoading: inProgress,
    toggleRequestFlyout: toggleRequestFlyout,
    isRequestFlyoutOpen: isRequestFlyoutOpen,
    reset: () => updatePayload({
      code: _constants.exampleScript
    })
  }), isRequestFlyoutOpen && /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    links: links,
    onClose: () => setRequestFlyoutOpen(false),
    requestBody: (0, _format.formatRequestPayload)(payload, _types.PayloadFormat.PRETTY),
    response: response ? (0, _format.formatJson)(response.result || response.error) : ''
  }));
};
exports.Main = Main;