"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSavedQueryRoute = void 0;
var _lodash = require("lodash");
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _types = require("../../../common/types");
var _utils = require("../utils");
var _utils2 = require("./utils");
var _find_saved_query_route = require("../../../common/api/saved_query/find_saved_query_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findSavedQueryRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'public',
    path: '/api/osquery/saved_queries',
    security: {
      authz: {
        requiredPrivileges: [`${_common.PLUGIN_ID}-readSavedQueries`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _route_validation.buildRouteValidation)(_find_saved_query_route.findSavedQueryRequestQuerySchema)
      }
    }
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.client;
    try {
      var _osqueryContext$servi;
      const savedQueries = await savedObjectsClient.find({
        type: _types.savedQuerySavedObjectType,
        page: request.query.page || 1,
        perPage: request.query.pageSize,
        sortField: request.query.sort || 'id',
        sortOrder: request.query.sortOrder || 'desc'
      });
      const prebuiltSavedQueriesMap = await (0, _utils2.getInstalledSavedQueriesMap)((_osqueryContext$servi = osqueryContext.service.getPackageService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser);
      const savedObjects = savedQueries.saved_objects.map(savedObject => {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        const ecs_mapping = savedObject.attributes.ecs_mapping;
        savedObject.attributes.prebuilt = !!prebuiltSavedQueriesMap[savedObject.id];
        if (ecs_mapping) {
          // @ts-expect-error update types
          savedObject.attributes.ecs_mapping = (0, _utils.convertECSMappingToObject)(ecs_mapping);
        }
        const {
          created_at: createdAt,
          created_by: createdBy,
          description,
          id,
          interval,
          timeout,
          platform,
          query,
          removed,
          snapshot,
          version,
          ecs_mapping: ecsMapping,
          updated_at: updatedAt,
          updated_by: updatedBy,
          prebuilt
        } = savedObject.attributes;
        return {
          created_at: createdAt,
          created_by: createdBy,
          description,
          id,
          removed,
          snapshot,
          version,
          ecs_mapping: ecsMapping,
          interval,
          timeout,
          platform,
          query,
          updated_at: updatedAt,
          updated_by: updatedBy,
          prebuilt,
          saved_object_id: savedObject.id
        };
      });
      return response.ok({
        body: {
          ...(0, _lodash.omit)(savedQueries, 'saved_objects'),
          data: savedObjects
        }
      });
    } catch (e) {
      var _e$output;
      return response.customError({
        statusCode: e.statusCode || ((_e$output = e.output) === null || _e$output === void 0 ? void 0 : _e$output.statusCode) || 500,
        body: e
      });
    }
  });
};
exports.findSavedQueryRoute = findSavedQueryRoute;