"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Resources = Resources;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Resources() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.observability.resources.title', {
    defaultMessage: 'Resources'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    listItems: resources,
    "data-test-subj": "listGroup",
    size: "s"
  }));
}
const resources = [{
  iconType: 'documents',
  label: _i18n.i18n.translate('xpack.observability.resources.documentation', {
    defaultMessage: 'Documentation'
  }),
  href: 'https://ela.st/observability-documentation'
}, {
  iconType: 'editorComment',
  label: _i18n.i18n.translate('xpack.observability.resources.forum', {
    defaultMessage: 'Discuss Forum'
  }),
  href: 'https://ela.st/observability-discuss'
}, {
  iconType: 'play',
  label: _i18n.i18n.translate('xpack.observability.resources.quick_start', {
    defaultMessage: 'Quick Start Videos'
  }),
  href: 'https://ela.st/observability-quick-starts'
}, {
  iconType: 'training',
  label: _i18n.i18n.translate('xpack.observability.resources.training', {
    defaultMessage: 'Free Observability Course'
  }),
  href: 'https://ela.st/observability-training'
}];