"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNewsFeed = getNewsFeed;
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Removes the suffix that is sometimes appended to the Kibana version,
 * (e.g. `8.0.0-SNAPSHOT-rc1`), which is typically only seen in non-production
 * environments
 */
const removeSuffixFromVersion = kibanaVersion => {
  var _semverCoerce$version, _semverCoerce;
  return (_semverCoerce$version = (_semverCoerce = (0, _coerce.default)(kibanaVersion)) === null || _semverCoerce === void 0 ? void 0 : _semverCoerce.version) !== null && _semverCoerce$version !== void 0 ? _semverCoerce$version : kibanaVersion;
};
async function getNewsFeed({
  http,
  kibanaVersion
}) {
  try {
    return await http.get(`https://feeds.elastic.co/observability-solution/v${removeSuffixFromVersion(kibanaVersion)}.json`);
  } catch (e) {
    console.error('Error while fetching news feed', e);
    return {
      items: []
    };
  }
}