"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingFlow = ObservabilityOnboardingFlow;
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _public = require("@kbn/kibana-react-plugin/public");
var _pages = require("./pages");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient();
function ObservabilityOnboardingFlow() {
  const {
    pathname
  } = (0, _reactRouterDomV5Compat.useLocation)();
  const {
    services: {
      context: {
        isDev,
        isCloud
      }
    }
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, [pathname]);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/auto-detect"
  }, /*#__PURE__*/_react.default.createElement(_pages.AutoDetectPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/kubernetes"
  }, /*#__PURE__*/_react.default.createElement(_pages.KubernetesPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/otel-kubernetes"
  }, /*#__PURE__*/_react.default.createElement(_pages.OtelKubernetesPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/otel-logs"
  }, /*#__PURE__*/_react.default.createElement(_pages.OtelLogsPage, null)), (isCloud || isDev) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/firehose"
  }, /*#__PURE__*/_react.default.createElement(_pages.FirehosePage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_pages.LandingPage, null))));
}