"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPureObservabilityLogsExplorerStateMachine = exports.createObservabilityLogsExplorerStateMachine = void 0;
var _xstate = require("xstate");
var _defaults = require("./defaults");
var _url_state_storage_service = require("./url_state_storage_service");
var _controller_service = require("./controller_service");
var _time_filter_service = require("./time_filter_service");
var _telemetry_events = require("./telemetry_events");
var _all_selection_service = require("./all_selection_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPureObservabilityLogsExplorerStateMachine = initialContext => /** @xstate-layout N4IgpgJg5mDOIC5QHkBGswCcBuBDVAlgDYEAuAngDID2UsAogB4AOR1mWAdAK4B2B-UgVwkAXpADEAbQAMAXUShm1WGQLVeikI0QBGABwBmTvt0AmAKwyZAThsXdAFkcWLAGhDk9Mi5zv+LQ0NTcwA2QwBfCI80DBx8YjIqWgYWNg5MTgE1EQJRASgAMUxqAFsAFQJSsELiUiwAZSxsAgBjMAkASQA5TvLOgEFKToAtegARAH1CgCVkAFlJ-vn6ac7KcvoZyYatgDVOgGF6WQUkEGVVIQ0tHQQLMw8vBGD9ThkzQxd9RxtPmwA7BYojF0M0EiQKDQ6ExWOwuNkhLl8rwiiVSgBVTBELq9fpDUYTaZzRYYmaUU5aS5qG7nO4PJ6IUL2ThWawfFzhXQ2RwgkCxcGESHJGFpeGZVocXBCVGHDSkEpEIhYCSHZDdcpzSiULaTQ4zegDTbjSnnanXTR0xAOGycXQWUJmfSmfQA14AxkIZm+X52AEAsyhfSWB58gXxIVJaGpOEZLKCYRiSA8XgAa141AA7rxo7D0o1SNKOpRkABxBqTegADQACiWDdsGuUjatDgAJAbdUsTU1KFQ0y2gO5fXScN2OQwA2wB-QyfQ2T3mGTGUIOwzL3TrxyBsNgiOJKEpPPi+M5JMQTh4EgQXNijINQv1CQl8uV2v13VNlt6jtdnvyKl+wtW4mVCGQTAcX0J3nQJQkXXRuU4Fx11MAMZDA4MomiEAMwgOAtHDPBI0PUVYywQCrnUQdtEQABaBdPDo3x-BY1j7ABXc4iIg8RRjfNMj4RFEzySAKIHECEG3RcfHedkPmXUJtxscxOMFHjbzIzIhORApijKSpqlqIh6kwJocDaMAxOAq0EDMAE3nnH5HBkcd9AeIJPVMJCWPsp1nCdMxVP3YUNP408kTEXT0SxIgrKoiTt1HR02TcwJHH9RxPVeWS5KcT5TB8ILuJCo87y4SUwGlAo5V4BVqCVcizSA+KbKdN5rHs5lDB5MDdDgxivRZdLV2ZMweUMUIAyKiEo1KzTwuE8QIDi2kh0QbrPRsH4-ECTcnPCQJImwwiZpIviT2088U3TLMczm-iHyLFbqLuV1FzMZzODAnlAwymRdBkXljr3YrZtIsLLpEi8rwIG97vFR76meiSp1tPr7McfQg0MCwMve9KIJsYILFdCwbGXQKsKAA */
(0, _xstate.createMachine)({
  context: initialContext,
  predictableActionArguments: true,
  id: 'ObservabilityLogsExplorer',
  initial: 'uninitialized',
  states: {
    uninitialized: {
      always: 'initializeAllSelection'
    },
    initializeAllSelection: {
      invoke: {
        src: 'initializeAllSelection',
        onDone: {
          target: 'initializingFromTimeFilterService',
          actions: ['storeAllSelection']
        },
        onError: 'initializingFromTimeFilterService'
      }
    },
    initializingFromTimeFilterService: {
      invoke: {
        src: 'initializeFromTimeFilterService'
      },
      on: {
        INITIALIZED_FROM_TIME_FILTER_SERVICE: {
          target: 'initializingFromUrl',
          actions: ['storeInitialTimeFilter']
        }
      }
    },
    initializingFromUrl: {
      invoke: {
        src: 'initializeFromUrl'
      },
      on: {
        INITIALIZED_FROM_URL: {
          target: '#creatingController',
          actions: ['storeInitialUrlState']
        }
      }
    },
    creatingController: {
      id: 'creatingController',
      invoke: {
        src: 'createController'
      },
      on: {
        CONTROLLER_CREATED: {
          target: 'initialized',
          actions: ['storeController']
        }
      }
    },
    initialized: {
      invoke: [{
        src: 'subscribeToLogsExplorerState'
      }, {
        src: 'subscribeToLogsExplorerPublicEvents'
      }],
      states: {
        unknownLogsExplorerState: {
          on: {
            LOGS_EXPLORER_STATE_CHANGED: {
              target: 'validLogsExplorerState',
              actions: ['storeLogsExplorerState', 'updateUrlFromLogsExplorerState']
            }
          }
        },
        validLogsExplorerState: {
          on: {
            LOGS_EXPLORER_STATE_CHANGED: {
              actions: ['storeLogsExplorerState', 'updateUrlFromLogsExplorerState'],
              target: 'validLogsExplorerState',
              internal: true
            },
            LOGS_EXPLORER_DATA_RECEIVED: {
              actions: ['trackDataReceived']
            }
          }
        }
      },
      initial: 'unknownLogsExplorerState'
    }
  }
}, {
  actions: {
    storeController: _xstate.actions.assign((context, event) => {
      return 'controller' in event && event.type === 'CONTROLLER_CREATED' ? {
        controller: event.controller
      } : {};
    }),
    storeAllSelection: _xstate.actions.assign((context, event) => {
      return 'data' in event ? {
        allSelection: event.data
      } : {};
    }),
    storeInitialTimeFilter: _xstate.actions.assign((context, event) => {
      return 'time' in event && 'refreshInterval' in event && event.type === 'INITIALIZED_FROM_TIME_FILTER_SERVICE' ? {
        initialLogsExplorerState: {
          ...('initialLogsExplorerState' in context ? context.initialLogsExplorerState : {}),
          ...{
            time: event.time,
            refreshInterval: event.refreshInterval
          }
        }
      } : {};
    }),
    storeInitialUrlState: _xstate.actions.assign((context, event) => {
      return 'stateFromUrl' in event && event.type === 'INITIALIZED_FROM_URL' ? {
        initialLogsExplorerState: {
          ...('initialLogsExplorerState' in context ? context.initialLogsExplorerState : {}),
          ...event.stateFromUrl
        }
      } : {};
    }),
    storeLogsExplorerState: _xstate.actions.assign((context, event) => {
      return 'state' in event && event.type === 'LOGS_EXPLORER_STATE_CHANGED' ? {
        logsExplorerState: event.state
      } : {};
    })
  },
  guards: {}
});
exports.createPureObservabilityLogsExplorerStateMachine = createPureObservabilityLogsExplorerStateMachine;
const createObservabilityLogsExplorerStateMachine = ({
  initialContext = _defaults.DEFAULT_CONTEXT,
  toasts,
  urlStateStorageContainer,
  createLogsExplorerController,
  timeFilterService,
  analytics,
  logSourcesService
}) => createPureObservabilityLogsExplorerStateMachine(initialContext).withConfig({
  actions: {
    updateUrlFromLogsExplorerState: (0, _url_state_storage_service.updateUrlFromLogsExplorerState)({
      urlStateStorageContainer
    }),
    trackDataReceived: (0, _telemetry_events.createDataReceivedTelemetryEventEmitter)(analytics)
  },
  services: {
    createController: (0, _controller_service.createController)({
      createLogsExplorerController
    }),
    initializeFromTimeFilterService: (0, _time_filter_service.initializeFromTimeFilterService)({
      timeFilterService
    }),
    initializeFromUrl: (0, _url_state_storage_service.initializeFromUrl)({
      urlStateStorageContainer,
      toastsService: toasts
    }),
    initializeAllSelection: (0, _all_selection_service.initializeAllSelection)({
      logSourcesService
    }),
    subscribeToLogsExplorerState: _controller_service.subscribeToLogsExplorerState,
    subscribeToLogsExplorerPublicEvents: _controller_service.subscribeToLogsExplorerPublicEvents
  }
});
exports.createObservabilityLogsExplorerStateMachine = createObservabilityLogsExplorerStateMachine;