"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryStateFromDiscoverAppState = exports.getGridRowsDisplayOptionsFromDiscoverAppState = exports.getGridColumnDisplayOptionsFromDiscoverAppState = exports.getDiscoverGridFromDisplayOptions = exports.getDiscoverFiltersFromState = exports.getDiscoverColumnsWithFallbackFieldsFromDisplayOptions = exports.getDiscoverColumnsFromDisplayOptions = exports.getDiscoverAppStateFromContext = exports.getChartDisplayOptionsFromDiscoverAppState = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGridColumnDisplayOptionsFromDiscoverAppState = discoverAppState => {
  var _discoverAppState$col;
  return (_discoverAppState$col = discoverAppState.columns) === null || _discoverAppState$col === void 0 ? void 0 : _discoverAppState$col.map(field => {
    var _discoverAppState$gri, _discoverAppState$gri2, _discoverAppState$gri3;
    if (field === _constants.CONTENT_FIELD || field === _constants.RESOURCE_FIELD) {
      return _constants.SMART_FALLBACK_FIELDS[field];
    }
    return {
      type: 'document-field',
      field,
      width: (_discoverAppState$gri = discoverAppState.grid) === null || _discoverAppState$gri === void 0 ? void 0 : (_discoverAppState$gri2 = _discoverAppState$gri.columns) === null || _discoverAppState$gri2 === void 0 ? void 0 : (_discoverAppState$gri3 = _discoverAppState$gri2[field]) === null || _discoverAppState$gri3 === void 0 ? void 0 : _discoverAppState$gri3.width
    };
  });
};
exports.getGridColumnDisplayOptionsFromDiscoverAppState = getGridColumnDisplayOptionsFromDiscoverAppState;
const getGridRowsDisplayOptionsFromDiscoverAppState = discoverAppState => ({
  ...(discoverAppState.rowHeight != null ? {
    rowHeight: discoverAppState.rowHeight
  } : {}),
  ...(discoverAppState.rowsPerPage != null ? {
    rowsPerPage: discoverAppState.rowsPerPage
  } : {})
});
exports.getGridRowsDisplayOptionsFromDiscoverAppState = getGridRowsDisplayOptionsFromDiscoverAppState;
const getChartDisplayOptionsFromDiscoverAppState = discoverAppState => {
  var _discoverAppState$bre;
  return {
    breakdownField: (_discoverAppState$bre = discoverAppState.breakdownField) !== null && _discoverAppState$bre !== void 0 ? _discoverAppState$bre : null
  };
};
exports.getChartDisplayOptionsFromDiscoverAppState = getChartDisplayOptionsFromDiscoverAppState;
const getQueryStateFromDiscoverAppState = discoverAppState => ({
  query: discoverAppState.query,
  filters: discoverAppState.filters
});
exports.getQueryStateFromDiscoverAppState = getQueryStateFromDiscoverAppState;
const getDiscoverAppStateFromContext = displayOptions => {
  var _displayOptions$chart;
  return {
    breakdownField: (_displayOptions$chart = displayOptions.chart.breakdownField) !== null && _displayOptions$chart !== void 0 ? _displayOptions$chart : undefined,
    columns: getDiscoverColumnsFromDisplayOptions(displayOptions),
    grid: getDiscoverGridFromDisplayOptions(displayOptions),
    rowHeight: displayOptions.grid.rows.rowHeight,
    rowsPerPage: displayOptions.grid.rows.rowsPerPage,
    query: (0, _lodash.cloneDeep)(displayOptions.query),
    filters: (0, _lodash.cloneDeep)(displayOptions.filters)
  };
};
exports.getDiscoverAppStateFromContext = getDiscoverAppStateFromContext;
const getDiscoverColumnsWithFallbackFieldsFromDisplayOptions = displayOptions => displayOptions.grid.columns.flatMap(column => {
  return column.type === 'document-field' ? column.field : _constants.SMART_FALLBACK_FIELDS[column.smartField].fallbackFields;
});
exports.getDiscoverColumnsWithFallbackFieldsFromDisplayOptions = getDiscoverColumnsWithFallbackFieldsFromDisplayOptions;
const getDiscoverColumnsFromDisplayOptions = displayOptions => displayOptions.grid.columns.flatMap(column => {
  return column.type === 'document-field' ? column.field : column.smartField;
});
exports.getDiscoverColumnsFromDisplayOptions = getDiscoverColumnsFromDisplayOptions;
const getDiscoverGridFromDisplayOptions = displayOptions => ({
  columns: displayOptions.grid.columns.reduce((gridColumns, column) => {
    const key = column.type === 'document-field' ? column.field : column.smartField;
    if (column.width != null) {
      gridColumns[key] = {
        width: column.width
      };
    }
    return gridColumns;
  }, {})
});
exports.getDiscoverGridFromDisplayOptions = getDiscoverGridFromDisplayOptions;
const createDiscoverPhrasesFilter = ({
  key,
  values,
  negate,
  index
}) => ({
  meta: {
    index,
    type: _esQuery.FILTERS.PHRASES,
    key,
    params: values.map(value => value.toString()),
    negate
  },
  query: {
    bool: {
      should: values.map(value => ({
        match_phrase: {
          [key]: value.toString()
        }
      })),
      minimum_should_match: 1
    }
  }
});
const createDiscoverExistsFilter = ({
  index,
  key,
  negate
}) => ({
  meta: {
    index,
    type: _esQuery.FILTERS.EXISTS,
    value: _esQuery.FILTERS.EXISTS,
    // Required for the filter to be displayed correctly in FilterBadge
    key,
    negate
  },
  query: {
    exists: {
      field: key
    }
  }
});
const getDiscoverFiltersFromState = (index, filters = [], controls) => {
  return [...filters, ...(controls ? Object.entries(controls).reduce((acc, [key, control]) => {
    if (control.selection.type === 'exists') {
      acc.push(createDiscoverExistsFilter({
        index,
        key,
        negate: control.mode === 'exclude'
      }));
    } else if (control.selection.selectedOptions.length > 0) {
      acc.push(createDiscoverPhrasesFilter({
        index,
        key,
        values: control.selection.selectedOptions,
        negate: control.mode === 'exclude'
      }));
    }
    return acc;
  }, []) : [])];
};
exports.getDiscoverFiltersFromState = getDiscoverFiltersFromState;