"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONTEXT = void 0;
var _constants = require("../../../../common/constants");
var _default_all_selection = require("./default_all_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  dataSourceSelection: _default_all_selection.DEFAULT_ALL_SELECTION,
  allSelection: _default_all_selection.DEFAULT_ALL_SELECTION,
  grid: {
    columns: _constants.DEFAULT_COLUMNS,
    rows: {
      rowHeight: _constants.DEFAULT_ROW_COUNT,
      rowsPerPage: _constants.DEFAULT_ROWS_PER_PAGE
    }
  },
  chart: {
    breakdownField: _constants.LOG_LEVEL_FIELD
  },
  filters: [],
  query: {
    language: 'kuery',
    query: ''
  },
  refreshInterval: {
    pause: true,
    value: 60000
  },
  time: {
    mode: 'relative',
    from: 'now-15m/m',
    to: 'now'
  },
  rows: []
};