"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreeNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../common/translations");
var _styles = require("./styles");
var _dynamic_tree_view = require("../dynamic_tree_view");
var _constants = require("./constants");
var _contexts = require("../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TreeNav = () => {
  const styles = (0, _styles.useStyles)();
  const [tree, setTree] = (0, _react.useState)(_constants.TREE_VIEW.logical);
  const {
    filterQueryWithTimeRange,
    onTreeNavSelect,
    treeNavSelection,
    setTreeNavSelection
  } = (0, _contexts.useTreeViewContext)();
  const [isCollapsed, setIsCollapsed] = (0, _react.useState)(false);
  const treeNavTypePrefix = (0, _eui.useGeneratedHtmlId)({
    prefix: 'treeNavType'
  });
  const logicalTreeViewPrefix = `${treeNavTypePrefix}${_constants.LOGICAL}`;
  const [toggleIdSelected, setToggleIdSelected] = (0, _react.useState)(logicalTreeViewPrefix);
  const selected = (0, _react.useMemo)(() => {
    return Object.entries(treeNavSelection).map(([k, v]) => `${k}.${v}`).join();
  }, [treeNavSelection]);
  const handleToggleCollapse = () => {
    setIsCollapsed(!isCollapsed);
  };
  const options = (0, _react.useMemo)(() => [{
    id: logicalTreeViewPrefix,
    label: _translations.TREE_VIEW_LOGICAL_VIEW,
    value: _constants.LOGICAL
  }, {
    id: `${treeNavTypePrefix}${_constants.INFRASTRUCTURE}`,
    label: _translations.TREE_VIEW_INFRASTRUCTURE_VIEW,
    value: _constants.INFRASTRUCTURE
  }], [logicalTreeViewPrefix, treeNavTypePrefix]);
  const handleTreeViewSwitch = (0, _react.useCallback)((id, value) => {
    setToggleIdSelected(id);
    setTree(_constants.TREE_VIEW[value]);
    setTreeNavSelection({});
  }, [setTreeNavSelection]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCollapsed && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TREE_NAVIGATION_EXPAND
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: handleToggleCollapse,
    iconType: "menuRight",
    "aria-label": _translations.TREE_NAVIGATION_EXPAND
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: isCollapsed ? 'none' : 'inherit'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    name: "coarsness",
    legend: _translations.TREE_VIEW_SWITCHER_LEGEND,
    options: options,
    idSelected: toggleIdSelected,
    onChange: handleTreeViewSwitch,
    buttonSize: "compressed",
    isFullWidth: true,
    color: "primary",
    css: styles.treeViewSwitcher
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TREE_NAVIGATION_COLLAPSE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: handleToggleCollapse,
    iconType: "menuLeft",
    "aria-label": _translations.TREE_NAVIGATION_COLLAPSE
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    css: styles.treeViewLegend
  }, tree.map(t => t.name).join(' / ')), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.treeViewContainer,
    className: "eui-scrollBar"
  }, /*#__PURE__*/_react.default.createElement(_dynamic_tree_view.DynamicTreeView, {
    query: filterQueryWithTimeRange,
    tree: tree,
    selected: selected,
    onSelect: (selectionDepth, type, key, clusterName) => {
      const newSelectionDepth = {
        ...selectionDepth,
        [type]: key,
        ...(clusterName && {
          clusterName
        })
      };
      onTreeNavSelect(newSelectionDepth);
    }
  }))));
};
exports.TreeNav = TreeNav;