"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputControlVis = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _editor_utils = require("../../editor_utils");
var _list_control = require("./list_control");
var _range_control = require("./range_control");
require("./input_control_vis.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isListControl(control) {
  return control.type === _editor_utils.CONTROL_TYPES.LIST;
}
function isRangeControl(control) {
  return control.type === _editor_utils.CONTROL_TYPES.RANGE;
}
class InputControlVis extends _react.Component {
  constructor(props) {
    super(props);
    this.handleSubmit = this.handleSubmit.bind(this);
    this.handleReset = this.handleReset.bind(this);
    this.handleClearAll = this.handleClearAll.bind(this);
  }
  handleSubmit() {
    this.props.submitFilters();
  }
  handleReset() {
    this.props.resetControls();
  }
  handleClearAll() {
    this.props.clearControls();
  }
  renderControls() {
    return this.props.controls.map((control, index) => {
      let controlComponent = null;
      if (isListControl(control)) {
        controlComponent = /*#__PURE__*/_react.default.createElement(_list_control.ListControl, {
          id: control.id,
          label: control.label,
          options: control.selectOptions,
          selectedOptions: control.value,
          formatOptionLabel: control.format,
          disableMsg: control.isEnabled() ? undefined : control.disabledReason,
          multiselect: control.options.multiselect,
          partialResults: control.partialResults,
          dynamicOptions: control.options.dynamicOptions,
          controlIndex: index,
          stageFilter: this.props.stageFilter,
          fetchOptions: query => {
            this.props.refreshControl(index, query);
          },
          isDarkMode: this.props.isDarkMode
        });
      } else if (isRangeControl(control)) {
        controlComponent = /*#__PURE__*/_react.default.createElement(_range_control.RangeControl, {
          control: control,
          controlIndex: index,
          stageFilter: this.props.stageFilter
        });
      } else {
        throw new Error(`Unhandled control type ${control.type}`);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: control.id,
        css: {
          minWidth: '250px'
        },
        "data-test-subj": "inputControlItem"
      }, controlComponent);
    });
  }
  renderStagingButtons() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleSubmit,
      disabled: !this.props.hasChanges(),
      "data-test-subj": "inputControlSubmitBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.applyChangesButtonLabel",
      defaultMessage: "Apply changes"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.handleReset,
      disabled: !this.props.hasChanges(),
      "data-test-subj": "inputControlCancelBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.cancelChangesButtonLabel",
      defaultMessage: "Cancel changes"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.handleClearAll,
      disabled: !this.props.hasValues(),
      "data-test-subj": "inputControlClearBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.vis.inputControlVis.clearFormButtonLabel",
      defaultMessage: "Clear form"
    }))));
  }
  render() {
    let stagingButtons;
    if (this.props.controls.length > 0 && !this.props.updateFiltersOnChange) {
      stagingButtons = this.renderStagingButtons();
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "icvContainer__wrapper"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "icvContainer"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true
    }, this.renderControls()), stagingButtons));
  }
}
exports.InputControlVis = InputControlVis;