"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisSectionPropsRT = exports.SeriesOverridesRT = exports.SeriesOverridesObjectRT = void 0;
var _ioTs = _interopRequireDefault(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartTypesRT = _ioTs.default.keyof({
  area: null,
  bar: null,
  line: null
});
const SeriesOverridesObjectRT = exports.SeriesOverridesObjectRT = _ioTs.default.intersection([_ioTs.default.type({
  color: _ioTs.default.string
}), _ioTs.default.partial({
  name: _ioTs.default.string,
  formatter: _common.InventoryFormatterTypeRT,
  formatterTemplate: _ioTs.default.string,
  gaugeMax: _ioTs.default.number,
  type: ChartTypesRT
})]);
const SeriesOverridesRT = exports.SeriesOverridesRT = _ioTs.default.record(_ioTs.default.string, _ioTs.default.union([_ioTs.default.undefined, SeriesOverridesObjectRT]));
const VisSectionPropsRT = exports.VisSectionPropsRT = _ioTs.default.partial({
  type: ChartTypesRT,
  stacked: _ioTs.default.boolean,
  formatter: _common.InventoryFormatterTypeRT,
  formatterTemplate: _ioTs.default.string,
  seriesOverrides: SeriesOverridesRT
});