"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelProvider = exports.ModelPlatform = exports.ModelFamily = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ModelPlatform = exports.ModelPlatform = /*#__PURE__*/function (ModelPlatform) {
  ModelPlatform["OpenAI"] = "OpenAI";
  ModelPlatform["AzureOpenAI"] = "AzureOpenAI";
  ModelPlatform["AmazonBedrock"] = "AmazonBedrock";
  ModelPlatform["GoogleVertex"] = "GoogleVertex";
  ModelPlatform["Elastic"] = "Elastic";
  ModelPlatform["Other"] = "other";
  return ModelPlatform;
}({});
let ModelProvider = exports.ModelProvider = /*#__PURE__*/function (ModelProvider) {
  ModelProvider["OpenAI"] = "OpenAI";
  ModelProvider["Anthropic"] = "Anthropic";
  ModelProvider["Google"] = "Google";
  ModelProvider["Other"] = "Other";
  ModelProvider["Elastic"] = "Elastic";
  return ModelProvider;
}({});
let ModelFamily = exports.ModelFamily = /*#__PURE__*/function (ModelFamily) {
  ModelFamily["GPT"] = "GPT";
  ModelFamily["Claude"] = "Claude";
  ModelFamily["Gemini"] = "Gemini";
  return ModelFamily;
}({});