"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichPoliciesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _redirect_path = require("../../../hooks/redirect_path");
var _breadcrumbs = require("../../../services/breadcrumbs");
var _documentation = require("../../../services/documentation");
var _api = require("../../../services/api");
var _policies_table = require("./policies_table");
var _confirm_modals = require("./confirm_modals");
var _empty_states = require("./empty_states");
var _details_flyout = require("./details_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEnrichPolicyNameFromLocation = location => {
  const {
    policy
  } = (0, _queryString.parse)(location.search.substring(1));
  return policy;
};
const EnrichPoliciesList = ({
  history,
  location
}) => {
  const {
    core: {
      executionContext
    },
    privs
  } = (0, _app_context.useAppContext)();
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.enrichPolicies);
  }, []);
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementEnrichPoliciesTab'
  });

  // Policy details flyout
  const enrichPolicyNameFromLocation = getEnrichPolicyNameFromLocation(location);
  const [showFlyoutFor, setShowFlyoutFor] = (0, _react.useState)();

  // Policy table actions
  const [policyToDelete, setPolicyToDelete] = (0, _react.useState)();
  const [policyToExecute, setPolicyToExecute] = (0, _react.useState)();
  const {
    error,
    isLoading,
    data: policies,
    resendRequest: reloadPolicies
  } = (0, _api.useLoadEnrichPolicies)();
  (0, _react.useEffect)(() => {
    if (enrichPolicyNameFromLocation && policies !== null && policies !== void 0 && policies.length) {
      const policy = policies.find(p => p.name === enrichPolicyNameFromLocation);
      setShowFlyoutFor(policy);
    }
  }, [enrichPolicyNameFromLocation, policies]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.LoadingState, null);
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.ErrorState, {
      error: error,
      resendRequest: reloadPolicies
    });
  }
  if (privs.manageEnrich && (policies === null || policies === void 0 ? void 0 : policies.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.EmptyState, null);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _shared_imports.APP_WRAPPER_CLASS,
    "data-test-subj": "enrichPoliciesList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.list.descriptionTitle",
    defaultMessage: "Use an enrich policy to automatically enhance your incoming documents with data from your existing indices. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getEnrichApisLink(),
        target: "_blank",
        external: true,
        "data-test-subj": "enrichPoliciesLearnMoreLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.enrichPolicies.list.docsLink",
        defaultMessage: "Learn more"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_policies_table.PoliciesTable, {
    policies: policies,
    onReloadClick: reloadPolicies,
    onDeletePolicyClick: setPolicyToDelete,
    onExecutePolicyClick: setPolicyToExecute
  }), policyToDelete && /*#__PURE__*/_react.default.createElement(_confirm_modals.DeletePolicyModal, {
    policyToDelete: policyToDelete,
    callback: deleteResponse => {
      if (deleteResponse !== null && deleteResponse !== void 0 && deleteResponse.hasDeletedPolicy) {
        reloadPolicies();
      }
      setPolicyToDelete(undefined);
    }
  }), policyToExecute && /*#__PURE__*/_react.default.createElement(_confirm_modals.ExecutePolicyModal, {
    policyToExecute: policyToExecute,
    callback: executeResponse => {
      if (executeResponse !== null && executeResponse !== void 0 && executeResponse.hasExecutedPolicy) {
        reloadPolicies();
      }
      setPolicyToExecute(undefined);
    }
  }), showFlyoutFor && /*#__PURE__*/_react.default.createElement(_details_flyout.PolicyDetailsFlyout, {
    policy: showFlyoutFor,
    onClose: () => {
      setShowFlyoutFor(undefined);
      redirectTo('/enrich_policies');
    }
  }));
};
exports.EnrichPoliciesList = EnrichPoliciesList;