"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsPromotion = StreamsPromotion;
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamsPromotion({
  dataStreamName
}) {
  var _useObservable;
  const {
    url,
    plugins: {
      streams
    }
  } = (0, _app_context.useAppContext)();
  const streamsEnabled = ((_useObservable = (0, _useObservable2.default)((streams === null || streams === void 0 ? void 0 : streams.status$) || _rxjs.EMPTY)) === null || _useObservable === void 0 ? void 0 : _useObservable.status) === 'enabled';
  const streamsLocator = url.locators.get('STREAMS_APP_LOCATOR');
  if (!streamsEnabled || !streamsLocator) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.title', {
      defaultMessage: 'Explore the New Streams UI in Technical Preview'
    }),
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.description', {
    defaultMessage: 'A better way to manage your data streams is here! The new Streams UI provides a streamlined experience with improved insights and management tools.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => streamsLocator.navigate({
      name: dataStreamName
    })
  }, _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.button', {
    defaultMessage: 'Go to Streams'
  })))));
}