"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuideButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _guide_button_popover = require("./guide_button_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getStepNumber = state => {
  let stepNumber;
  state === null || state === void 0 ? void 0 : state.steps.forEach((step, stepIndex) => {
    // If the step is in_progress or ready_to_complete, show that step number
    if (step.status === 'in_progress' || step.status === 'ready_to_complete') {
      stepNumber = stepIndex + 1;
    }

    // If the step is active, show the previous step number
    if (step.status === 'active') {
      stepNumber = stepIndex;
    }
  });
  return stepNumber;
};
const GuideButton = ({
  pluginState,
  guideConfig,
  toggleGuidePanel,
  isGuidePanelOpen,
  navigateToLandingPage,
  isLoading
}) => {
  var _pluginState$activeGu;
  const stepNumber = getStepNumber(pluginState === null || pluginState === void 0 ? void 0 : pluginState.activeGuide);
  const stepReadyToComplete = pluginState === null || pluginState === void 0 ? void 0 : (_pluginState$activeGu = pluginState.activeGuide) === null || _pluginState$activeGu === void 0 ? void 0 : _pluginState$activeGu.steps.find(step => step.status === 'ready_to_complete');
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    onClick: toggleGuidePanel,
    color: "success",
    fill: true,
    size: "s",
    "data-test-subj": "guideButton"
  }, Boolean(stepNumber) ? _i18n.i18n.translate('guidedOnboarding.guidedSetupStepButtonLabel', {
    defaultMessage: 'Setup guide: step {stepNumber}',
    values: {
      stepNumber
    }
  }) : _i18n.i18n.translate('guidedOnboarding.guidedSetupButtonLabel', {
    defaultMessage: 'Setup guide'
  }));
  // if there is no active guide
  if (!pluginState || !pluginState.activeGuide || !pluginState.activeGuide.isActive ||
  // the guide has not started yet when the user just looks at the guide
  // see https://github.com/elastic/kibana/issues/148912 for more context
  pluginState.activeGuide.status === 'not_started') {
    // if still active period and the user has not started a guide or skipped the guide,
    // display the button that redirects to the landing page
    if (pluginState !== null && pluginState !== void 0 && pluginState.isActivePeriod && ((pluginState === null || pluginState === void 0 ? void 0 : pluginState.status) === 'not_started' || (pluginState === null || pluginState === void 0 ? void 0 : pluginState.status) === 'skipped' ||
    // plugin state 'in_progress' without an active guide is when the guide has not started yet
    // see https://github.com/elastic/kibana/issues/148912 for context
    pluginState.status === 'in_progress')) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: navigateToLandingPage,
        color: "success",
        fill: true,
        size: "s",
        "data-test-subj": "guideButtonRedirect"
      }, _i18n.i18n.translate('guidedOnboarding.guidedSetupRedirectButtonLabel', {
        defaultMessage: 'Setup guides'
      }));
    }
    // if error state, display the header button (error section is in the dropdown panel)
    if ((pluginState === null || pluginState === void 0 ? void 0 : pluginState.status) === 'error') {
      return button;
    }
    // otherwise hide the button (the guide is completed, quit, skipped or not started)
    return null;
  }
  if (stepReadyToComplete) {
    const stepConfig = guideConfig === null || guideConfig === void 0 ? void 0 : guideConfig.steps.find(step => step.id === stepReadyToComplete.id);
    // check if the stepConfig has manualCompletion info
    if (stepConfig && stepConfig.manualCompletion) {
      return /*#__PURE__*/_react.default.createElement(_guide_button_popover.GuideButtonPopover, {
        button: button,
        isGuidePanelOpen: isGuidePanelOpen,
        title: stepConfig.manualCompletion.title,
        description: stepConfig.manualCompletion.description
      });
    }
  }
  return button;
};
exports.GuideButton = GuideButton;